/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Digest
implements Externalizable,
Streamable {
    Map senders = null;
    protected static final Log log = LogFactory.getLog((Class)Digest.class);
    static final boolean warn = log.isWarnEnabled();

    public Digest() {
    }

    public Digest(int size) {
        this.senders = this.createSenders(size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Digest other = (Digest)obj;
        if (this.senders == null && other.senders == null) {
            return true;
        }
        return ((Object)this.senders).equals(other.senders);
    }

    public void add(Address sender, long low_seqno, long high_seqno) {
        this.add(sender, low_seqno, high_seqno, -1L);
    }

    public void add(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        this.add(sender, new Entry(low_seqno, high_seqno, high_seqno_seen));
    }

    private void add(Address sender, Entry entry) {
        if (sender == null || entry == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("sender (" + sender + ") or entry (" + entry + ")is null, will not add entry"));
            }
            return;
        }
        Entry retval = this.senders.put(sender, entry);
        if (retval != null && warn) {
            log.warn((Object)("entry for " + sender + " was overwritten with " + entry));
        }
    }

    public void add(Digest d) {
        if (d != null) {
            Iterator it = d.senders.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address key = (Address)entry.getKey();
                Entry val = (Entry)entry.getValue();
                this.add(key, val.low_seqno, val.high_seqno, val.high_seqno_seen);
            }
        }
    }

    public void replace(Digest d) {
        if (d != null) {
            this.clear();
            Iterator it = d.senders.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address key = (Address)entry.getKey();
                Entry val = (Entry)entry.getValue();
                this.add(key, val.low_seqno, val.high_seqno, val.high_seqno_seen);
            }
        }
    }

    public Entry get(Address sender) {
        return (Entry)this.senders.get(sender);
    }

    public boolean set(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return false;
        }
        entry.low_seqno = low_seqno;
        entry.high_seqno = high_seqno;
        entry.high_seqno_seen = high_seqno_seen;
        return true;
    }

    public void merge(Digest d) {
        if (d == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"digest to be merged with is null");
            }
            return;
        }
        Iterator it = d.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address sender = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (val == null) continue;
            this.merge(sender, val.low_seqno, val.high_seqno, val.high_seqno_seen);
        }
    }

    public void merge(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        if (sender == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"sender == null");
            }
            return;
        }
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            this.add(sender, low_seqno, high_seqno, high_seqno_seen);
        } else {
            if (low_seqno < entry.low_seqno) {
                entry.low_seqno = low_seqno;
            }
            if (high_seqno > entry.high_seqno) {
                entry.high_seqno = high_seqno;
            }
            if (high_seqno_seen > entry.high_seqno_seen) {
                entry.high_seqno_seen = high_seqno_seen;
            }
        }
    }

    public boolean contains(Address sender) {
        return this.senders.containsKey(sender);
    }

    public boolean sameSenders(Digest other) {
        if (other == null) {
            return false;
        }
        if (this.senders == null || other.senders == null) {
            return false;
        }
        if (this.senders.size() != other.senders.size()) {
            return false;
        }
        Set my_senders = this.senders.keySet();
        Set other_senders = other.senders.keySet();
        return ((Object)my_senders).equals(other_senders);
    }

    public void incrementHighSeqno(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return;
        }
        ++entry.high_seqno;
    }

    public int size() {
        return this.senders.size();
    }

    public void resetAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.reset();
        }
    }

    public void clear() {
        this.senders.clear();
    }

    public long lowSeqnoAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.low_seqno;
    }

    public long highSeqnoAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.high_seqno;
    }

    public long highSeqnoSeenAt(Address sender) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.high_seqno_seen;
    }

    public void setHighSeqnoAt(Address sender, long high_seqno) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.high_seqno = high_seqno;
        }
    }

    public void setHighSeqnoSeenAt(Address sender, long high_seqno_seen) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.high_seqno_seen = high_seqno_seen;
        }
    }

    public void setHighestDeliveredAndSeenSeqnos(Address sender, long high_seqno, long high_seqno_seen) {
        Entry entry = (Entry)this.senders.get(sender);
        if (entry != null) {
            entry.high_seqno = high_seqno;
            entry.high_seqno_seen = high_seqno_seen;
        }
    }

    public Digest copy() {
        Digest ret = new Digest(this.senders.size());
        Iterator it = this.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Entry tmp = (Entry)entry.getValue();
            ret.add((Address)entry.getKey(), tmp.low_seqno, tmp.high_seqno, tmp.high_seqno_seen);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (this.senders == null) {
            return "[]";
        }
        Iterator it = this.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address key = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(val.low_seqno).append(" : ");
            sb.append(val.high_seqno);
            if (val.high_seqno_seen >= 0L) {
                sb.append(" (").append(val.high_seqno_seen).append(")");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String printHighSeqnos() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = this.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address key = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(key).append("#").append(val.high_seqno);
        }
        sb.append(']');
        return sb.toString();
    }

    public String printHighSeqnosSeen() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = this.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address key = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(key).append("#").append(val.high_seqno_seen);
        }
        sb.append(']');
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.senders);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.senders = (Map)in.readObject();
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeShort(this.senders.size());
        Iterator it = this.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address key = (Address)entry.getKey();
            Entry val = (Entry)entry.getValue();
            Util.writeAddress(key, out);
            out.writeLong(val.low_seqno);
            out.writeLong(val.high_seqno);
            out.writeLong(val.high_seqno_seen);
        }
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int size = in.readShort();
        this.senders = this.createSenders(size);
        for (int i = 0; i < size; ++i) {
            Address key = Util.readAddress(in);
            this.add(key, in.readLong(), in.readLong(), in.readLong());
        }
    }

    public long serializedSize() {
        long retval = 2L;
        if (this.senders.size() > 0) {
            Address addr = (Address)this.senders.keySet().iterator().next();
            int len = addr.size() + 2;
            retval += (long)((len += 24) * this.senders.size());
        }
        return retval;
    }

    private Map createSenders(int size) {
        return new ConcurrentReaderHashMap(size);
    }

    public static class Entry {
        public long low_seqno;
        public long high_seqno;
        public long high_seqno_seen = -1L;

        public Entry(long low_seqno, long high_seqno, long high_seqno_seen) {
            this.low_seqno = low_seqno;
            this.high_seqno = high_seqno;
            this.high_seqno_seen = high_seqno_seen;
        }

        public Entry(long low_seqno, long high_seqno) {
            this.low_seqno = low_seqno;
            this.high_seqno = high_seqno;
        }

        public Entry(Entry other) {
            if (other != null) {
                this.low_seqno = other.low_seqno;
                this.high_seqno = other.high_seqno;
                this.high_seqno_seen = other.high_seqno_seen;
            }
        }

        public boolean equals(Object obj) {
            Entry other = (Entry)obj;
            return this.low_seqno == other.low_seqno && this.high_seqno == other.high_seqno && this.high_seqno_seen == other.high_seqno_seen;
        }

        public String toString() {
            return "low=" + this.low_seqno + ", high=" + this.high_seqno + ", highest seen=" + this.high_seqno_seen;
        }

        public void reset() {
            this.high_seqno = 0L;
            this.low_seqno = 0L;
            this.high_seqno_seen = -1L;
        }
    }
}

