/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javassist.runtime.Desc;
import org.jboss.lang.ExceptionHelper;
import org.jboss.lang.JBossStringBuilder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicLongFieldUpdater<T> {
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> tClass, String fieldName) {
        return new Implementation<U>(tClass, fieldName);
    }

    protected AtomicLongFieldUpdater() {
    }

    public long addAndGet(T obj, long delta) {
        long update;
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + delta)) {
        }
        return update;
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public long decrementAndGet(T obj) {
        long update;
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect - 1L)) {
        }
        return update;
    }

    public abstract long get(T var1);

    public long getAndAdd(T obj, long delta) {
        long update;
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + delta)) {
        }
        return expect;
    }

    public long getAndDecrement(T obj) {
        long update;
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect - 1L)) {
        }
        return expect;
    }

    public long getAndIncrement(T obj) {
        long update;
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + 1L)) {
        }
        return expect;
    }

    public long getAndSet(T obj, long newValue) {
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), newValue)) {
        }
        return expect;
    }

    public long incrementAndGet(T obj) {
        long update;
        long expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + 1L)) {
        }
        return update;
    }

    public abstract void set(T var1, long var2);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Implementation<T>
    extends AtomicLongFieldUpdater<T> {
        private Class<T> tClass;
        private String fieldName;
        private Field field;

        public Implementation(Class<T> tClass, String fieldName) {
            if (tClass == null) {
                throw new IllegalArgumentException("Null class");
            }
            if (fieldName == null) {
                throw new IllegalArgumentException("Null field name");
            }
            this.tClass = tClass;
            this.fieldName = fieldName;
            try {
                this.field = tClass.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                Exception exception = e;
                String string = new JBossStringBuilder().append("Cannot find field class=").append(tClass.getName()).append(" field=").append(fieldName).toString();
                Object var4_6 = null;
                Throwable throwable = null;
                throwable = ExceptionHelper.createExceptionWithCause(Desc.getClazz((String)"java.lang.IllegalArgumentException"), string, exception);
                throw throwable;
            }
            if (Long.TYPE != this.field.getType()) {
                throw new IllegalArgumentException(new JBossStringBuilder().append("Field is not a long class=").append(tClass.getName()).append(" field=").append(fieldName).toString());
            }
            if (!Modifier.isVolatile(this.field.getModifiers())) {
                throw new IllegalArgumentException(new JBossStringBuilder().append("Field is not volatile class=").append(tClass.getName()).append(" field=").append(fieldName).toString());
            }
            this.field.setAccessible(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndSet(T obj, long expect, long update) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    long value = this.field.getLong(obj);
                    if (value != expect) {
                        return false;
                    }
                    this.field.setLong(obj, update);
                    return true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new JBossStringBuilder().append("Unexpected error class=").append(this.tClass.getName()).append(" field=").append(this.fieldName).toString(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long get(T obj) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    return this.field.getLong(obj);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new JBossStringBuilder().append("Unexpected error class=").append(this.tClass.getName()).append(" field=").append(this.fieldName).toString(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T obj, long newValue) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    this.field.setLong(obj, newValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new JBossStringBuilder().append("Unexpected error class=").append(this.tClass.getName()).append(" field=").append(this.fieldName).toString(), e);
            }
        }

        @Override
        public boolean weakCompareAndSet(T obj, long expect, long update) {
            return this.compareAndSet(obj, expect, update);
        }
    }
}

