/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

public class NumberHelper {
    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 1;
        if (i >>> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >>> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    public static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - (i << 1 >>> 31);
    }

    public static int bitCount(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        i = i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
        return i;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static int reverseBytes(int i) {
        return i >>> 24 | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    public static long highestOneBit(long i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        i |= i >> 32;
        return i - (i >>> 1);
    }

    public static long lowestOneBit(long i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(i >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)i;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static int numberOfTrailingZeros(long i) {
        int x;
        if (i == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)i;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(i >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    public static int bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    public static long rotateLeft(long i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static long reverse(long i) {
        i = (i & 0x5555555555555555L) << 1 | i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) << 2 | i >>> 2 & 0x3333333333333333L;
        i = (i & 0xF0F0F0F0F0F0F0FL) << 4 | i >>> 4 & 0xF0F0F0F0F0F0F0FL;
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        i = i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
        return i;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        return i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
    }
}

