/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.jboss.jms.message.JBossMessage;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.util.Primitives;

public class JBossStreamMessage
extends JBossMessage
implements StreamMessage {
    private static final long serialVersionUID = 7469150228071568233L;
    public static final byte TYPE = 6;
    protected transient int position;
    protected transient int offset;
    protected int size;

    public JBossStreamMessage() {
    }

    public JBossStreamMessage(long messageID) {
        super(messageID);
        this.setPayload(new ArrayList());
        this.clearPayloadAsByteArray();
        this.position = 0;
        this.size = 0;
        this.offset = 0;
    }

    public JBossStreamMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray) {
        super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
    }

    public JBossStreamMessage(JBossStreamMessage other) {
        super(other);
    }

    public JBossStreamMessage(StreamMessage foreign, long id) throws JMSException {
        super((Message)foreign, id);
        foreign.reset();
        this.setPayload(new ArrayList());
        this.clearPayloadAsByteArray();
        this.position = 0;
        this.size = 0;
        this.offset = 0;
        try {
            while (true) {
                Object obj = foreign.readObject();
                this.writeObject(obj);
            }
        }
        catch (MessageEOFException e) {
            return;
        }
    }

    public byte getType() {
        return 6;
    }

    public void doBeforeSend() throws JMSException {
        this.reset();
    }

    public void copyPayload(Object other) throws JMSException {
        this.reset();
        this.setPayload(new ArrayList((List)other));
        this.clearPayloadAsByteArray();
    }

    public boolean readBoolean() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Boolean) {
                ++this.position;
                return (Boolean)value;
            }
            if (value instanceof String) {
                boolean result = Boolean.valueOf((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return (Byte)value;
            }
            if (value instanceof String) {
                byte result = Byte.parseByte((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).shortValue();
            }
            if (value instanceof Short) {
                ++this.position;
                return (Short)value;
            }
            if (value instanceof String) {
                short result = Short.parseShort((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Character) {
                ++this.position;
                return ((Character)value).charValue();
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).intValue();
            }
            if (value instanceof Short) {
                ++this.position;
                return ((Short)value).intValue();
            }
            if (value instanceof Integer) {
                ++this.position;
                return (Integer)value;
            }
            if (value instanceof String) {
                int result = Integer.parseInt((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).longValue();
            }
            if (value instanceof Short) {
                ++this.position;
                return ((Short)value).longValue();
            }
            if (value instanceof Integer) {
                ++this.position;
                return ((Integer)value).longValue();
            }
            if (value instanceof Long) {
                ++this.position;
                return (Long)value;
            }
            if (value instanceof String) {
                long result = Long.parseLong((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Float) {
                ++this.position;
                return ((Float)value).floatValue();
            }
            if (value instanceof String) {
                float result = Float.parseFloat((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Float) {
                ++this.position;
                return ((Float)value).doubleValue();
            }
            if (value instanceof Double) {
                ++this.position;
                return (Double)value;
            }
            if (value instanceof String) {
                double result = Double.parseDouble((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readString() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            this.offset = 0;
            if (value == null) {
                ++this.position;
                return null;
            }
            if (value instanceof Boolean) {
                ++this.position;
                return ((Boolean)value).toString();
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).toString();
            }
            if (value instanceof Short) {
                ++this.position;
                return ((Short)value).toString();
            }
            if (value instanceof Character) {
                ++this.position;
                return ((Character)value).toString();
            }
            if (value instanceof Integer) {
                ++this.position;
                return ((Integer)value).toString();
            }
            if (value instanceof Long) {
                ++this.position;
                return ((Long)value).toString();
            }
            if (value instanceof Float) {
                ++this.position;
                return ((Float)value).toString();
            }
            if (value instanceof Double) {
                ++this.position;
                return ((Double)value).toString();
            }
            if (value instanceof String) {
                ++this.position;
                return (String)value;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        try {
            Object myObj = ((List)this.getPayload()).get(this.position);
            if (myObj == null) {
                throw new NullPointerException("Value is null");
            }
            if (!(myObj instanceof byte[])) {
                throw new MessageFormatException("Invalid conversion");
            }
            byte[] obj = (byte[])myObj;
            if (obj.length == 0) {
                ++this.position;
                this.offset = 0;
                return 0;
            }
            if (this.offset >= obj.length) {
                ++this.position;
                this.offset = 0;
                return -1;
            }
            if (obj.length - this.offset < value.length) {
                for (int i = 0; i < obj.length; ++i) {
                    value[i] = obj[i + this.offset];
                }
                ++this.position;
                this.offset = 0;
                return obj.length - this.offset;
            }
            for (int i = 0; i < value.length; ++i) {
                value[i] = obj[i + this.offset];
            }
            this.offset += value.length;
            return value.length;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public Object readObject() throws JMSException {
        try {
            Object value = ((List)this.getPayload()).get(this.position);
            ++this.position;
            this.offset = 0;
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        ((List)this.getPayload()).add(Primitives.valueOf((boolean)value));
    }

    public void writeByte(byte value) throws JMSException {
        ((List)this.getPayload()).add(new Byte(value));
    }

    public void writeShort(short value) throws JMSException {
        ((List)this.getPayload()).add(new Short(value));
    }

    public void writeChar(char value) throws JMSException {
        ((List)this.getPayload()).add(new Character(value));
    }

    public void writeInt(int value) throws JMSException {
        ((List)this.getPayload()).add(new Integer(value));
    }

    public void writeLong(long value) throws JMSException {
        ((List)this.getPayload()).add(new Long(value));
    }

    public void writeFloat(float value) throws JMSException {
        ((List)this.getPayload()).add(new Float(value));
    }

    public void writeDouble(double value) throws JMSException {
        ((List)this.getPayload()).add(new Double(value));
    }

    public void writeString(String value) throws JMSException {
        if (value == null) {
            ((List)this.getPayload()).add(null);
        } else {
            ((List)this.getPayload()).add(value);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        ((List)this.getPayload()).add(value.clone());
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (offset + length > value.length) {
            throw new JMSException("Array is too small");
        }
        byte[] temp = new byte[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = value[i + offset];
        }
        ((List)this.getPayload()).add(temp);
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            ((List)this.getPayload()).add(null);
        } else if (value instanceof Boolean) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Byte) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Short) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Character) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Integer) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Long) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Float) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof Double) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof String) {
            ((List)this.getPayload()).add(value);
        } else if (value instanceof byte[]) {
            ((List)this.getPayload()).add(((byte[])value).clone());
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public void reset() throws JMSException {
        this.position = 0;
        this.size = ((List)this.getPayload()).size();
        this.offset = 0;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.setPayload(new ArrayList());
        this.clearPayloadAsByteArray();
        this.position = 0;
        this.offset = 0;
        this.size = 0;
    }

    public JBossMessage doCopy() {
        return new JBossStreamMessage(this);
    }

    protected void writePayload(DataOutputStream out, Object thePayload) throws Exception {
        StreamUtils.writeList(out, (List)thePayload);
    }

    protected Object readPayload(DataInputStream in, int length) throws Exception {
        return StreamUtils.readList(in);
    }
}

