/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.DefaultCancel;
import org.jboss.jms.delegate.DeliveryInfo;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Future;
import org.jboss.messaging.util.prioritylinkedlist.BasicPriorityLinkedList;
import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedList;

public class ClientConsumer {
    private static final Logger log = Logger.getLogger(ClientConsumer.class);
    private static boolean trace = log.isTraceEnabled();
    private static final int WAIT_TIMEOUT = 30000;
    private PriorityLinkedList buffer;
    private SessionDelegate sessionDelegate;
    private ConsumerDelegate consumerDelegate;
    private String consumerID;
    private boolean isConnectionConsumer;
    private volatile Thread receiverThread;
    private MessageListener listener;
    private int ackMode;
    private boolean closed;
    private Object mainLock;
    private int maxBufferSize;
    private int minBufferSize;
    private QueuedExecutor sessionExecutor;
    private boolean listenerRunning;
    private int maxDeliveries;
    private String queueName;
    private long lastDeliveryId = -1L;
    private volatile boolean serverSending = true;
    private boolean waitingForLastDelivery;
    private boolean shouldAck;
    private boolean handleFlowControl;
    private long redeliveryDelay;

    private static boolean checkExpiredOrReachedMaxdeliveries(MessageProxy proxy, SessionDelegate del, int maxDeliveries, boolean shouldCancel) {
        boolean reachedMaxDeliveries;
        JBossMessage msg = proxy.getMessage();
        boolean expired = msg.isExpired();
        boolean bl = reachedMaxDeliveries = proxy.getDeliveryCount() == maxDeliveries;
        if (expired || reachedMaxDeliveries) {
            if (trace) {
                if (expired) {
                    log.trace((Object)(proxy.getMessage() + " has expired, cancelling to server"));
                } else {
                    log.trace((Object)(proxy.getMessage() + " has reached maximum delivery number " + maxDeliveries + ", cancelling to server"));
                }
            }
            if (shouldCancel) {
                DefaultCancel cancel = new DefaultCancel(proxy.getDeliveryId(), proxy.getDeliveryCount(), expired, reachedMaxDeliveries);
                try {
                    del.cancelDelivery(cancel);
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to cancel delivery", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    public static void callOnMessage(SessionDelegate sess, MessageListener listener, String consumerID, String queueName, boolean isConnectionConsumer, MessageProxy m, int ackMode, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck) throws JMSException {
        block9: {
            if (ClientConsumer.checkExpiredOrReachedMaxdeliveries(m, connectionConsumerSession != null ? connectionConsumerSession : sess, maxDeliveries, shouldAck)) {
                return;
            }
            DeliveryInfo deliveryInfo = new DeliveryInfo(m, consumerID, queueName, connectionConsumerSession, shouldAck);
            m.incDeliveryCount();
            if (!isConnectionConsumer) {
                sess.preDeliver(deliveryInfo);
            }
            try {
                if (trace) {
                    log.trace((Object)("calling listener's onMessage(" + m + ")"));
                }
                listener.onMessage((Message)m);
                if (trace) {
                    log.trace((Object)"listener's onMessage() finished");
                }
            }
            catch (RuntimeException e) {
                long id = m.getMessage().getMessageID();
                log.error((Object)("RuntimeException was thrown from onMessage, " + id + " will be redelivered"), (Throwable)e);
                if (ackMode != 1 && ackMode != 3) break block9;
                sess.recover();
            }
        }
        if (!isConnectionConsumer) {
            if (trace) {
                log.trace((Object)"Calling postDeliver");
            }
            sess.postDeliver();
            if (trace) {
                log.trace((Object)"Called postDeliver");
            }
        }
    }

    public ClientConsumer(boolean isCC, int ackMode, SessionDelegate sess, ConsumerDelegate cons, String consumerID, String queueName, int bufferSize, QueuedExecutor sessionExecutor, int maxDeliveries, boolean shouldAck, boolean handleFlowControl, long redeliveryDelay) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException(this + " bufferSize must be > 0");
        }
        this.maxBufferSize = bufferSize;
        this.minBufferSize = bufferSize / 2;
        this.buffer = new BasicPriorityLinkedList(10);
        this.isConnectionConsumer = isCC;
        this.ackMode = ackMode;
        this.sessionDelegate = sess;
        this.consumerDelegate = cons;
        this.consumerID = consumerID;
        this.queueName = queueName;
        this.mainLock = new Object();
        this.sessionExecutor = sessionExecutor;
        this.maxDeliveries = maxDeliveries;
        this.shouldAck = shouldAck;
        this.handleFlowControl = handleFlowControl;
        this.redeliveryDelay = redeliveryDelay;
    }

    public void handleMessage(final Object message) throws Exception {
        this.sessionExecutor.execute(new Runnable(){

            public void run() {
                try {
                    ClientConsumer.this.handleMessageInternal(message);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to handle message", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        Object object = this.mainLock;
        synchronized (object) {
            if (this.receiverThread != null) {
                throw new IllegalStateException("Consumer is currently in receive(..). Cannot set MessageListener");
            }
            this.listener = listener;
            if (listener != null && !this.buffer.isEmpty()) {
                this.listenerRunning = true;
                this.queueRunner(new ListenerRunner());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBuffer() throws JMSException {
        if (trace) {
            log.trace((Object)("Cancelling buffer: " + this.buffer.size()));
        }
        Object object = this.mainLock;
        synchronized (object) {
            if (this.shouldAck && !this.buffer.isEmpty()) {
                ArrayList<DefaultCancel> cancels = new ArrayList<DefaultCancel>();
                ListIterator i = this.buffer.iterator();
                while (i.hasNext()) {
                    MessageProxy mp = (MessageProxy)i.next();
                    DefaultCancel cancel = new DefaultCancel(mp.getDeliveryId(), mp.getDeliveryCount(), false, false);
                    cancels.add(cancel);
                }
                if (trace) {
                    log.trace((Object)"Calling cancelDeliveries");
                }
                this.sessionDelegate.cancelDeliveries(cancels);
                if (trace) {
                    log.trace((Object)"Done call");
                }
                this.buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long lastDeliveryId) throws JMSException {
        log.trace((Object)(this + " closing"));
        this.waitForLastDelivery(lastDeliveryId);
        if (this.listener != null) {
            this.setMessageListener(null);
        }
        this.waitForOnMessageToComplete();
        Object object = this.mainLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.receiverThread != null) {
                this.mainLock.notify();
            }
            this.listener = null;
        }
        if (trace) {
            log.trace((Object)(this + " closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public MessageProxy receive(long timeout) throws JMSException {
        MessageProxy m = null;
        Object object = this.mainLock;
        // MONITORENTER : object
        if (trace) {
            log.trace((Object)(this + " receiving, timeout = " + timeout));
        }
        if (this.closed) {
            if (trace) {
                log.trace((Object)(this + " closed, returning null"));
            }
            // MONITOREXIT : object
            return null;
        }
        if (this.listener != null) {
            throw new JMSException("The consumer has a MessageListener set, cannot call receive(..)");
        }
        this.receiverThread = Thread.currentThread();
        long startTimestamp = System.currentTimeMillis();
        try {
            while (true) {
                if (timeout == 0L) {
                    if (trace) {
                        log.trace((Object)(this + ": receive, no timeout"));
                    }
                    if ((m = this.getMessage(0L)) == null) {
                        MessageProxy messageProxy = null;
                        return messageProxy;
                    }
                } else if (timeout == -1L) {
                    if (trace) {
                        log.trace((Object)(this + ": receive, noWait"));
                    }
                    if ((m = this.getMessage(-1L)) == null) {
                        if (trace) {
                            log.trace((Object)(this + ": no message available"));
                        }
                        MessageProxy messageProxy = null;
                        return messageProxy;
                    }
                } else {
                    if (trace) {
                        log.trace((Object)(this + ": receive, timeout " + timeout + " ms, blocking poll on queue"));
                    }
                    if ((m = this.getMessage(timeout)) == null) {
                        if (trace) {
                            log.trace((Object)(this + ": " + timeout + " ms timeout expired"));
                        }
                        MessageProxy messageProxy = null;
                        return messageProxy;
                    }
                }
                if (trace) {
                    log.trace((Object)(this + " received " + m + " after being blocked on buffer"));
                }
                boolean ignore = ClientConsumer.checkExpiredOrReachedMaxdeliveries(m, this.sessionDelegate, this.maxDeliveries, this.shouldAck);
                if (!this.isConnectionConsumer && !ignore) {
                    DeliveryInfo info = new DeliveryInfo(m, this.consumerID, this.queueName, null, this.shouldAck);
                    m.incDeliveryCount();
                    this.sessionDelegate.preDeliver(info);
                    this.sessionDelegate.postDeliver();
                }
                if (!ignore) {
                    if (trace) {
                        log.trace((Object)(this + ": message " + m + " is not expired, pushing it to the caller"));
                    }
                    break;
                }
                if (trace) {
                    log.trace((Object)(this + ": message expired or exceeded max deliveries, discarding"));
                }
                if (timeout == 0L || (timeout -= System.currentTimeMillis() - startTimestamp) != 0L) continue;
                timeout = -1L;
            }
        }
        finally {
            this.receiverThread = null;
        }
        // MONITOREXIT : object
        if (this.handleFlowControl) {
            this.checkStart();
        }
        if (!trace) return m;
        log.trace((Object)(this + " receive() returning " + m));
        return m;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public String toString() {
        return "ClientConsumer[" + this.consumerID + "]";
    }

    public String getConsumerId() {
        return this.consumerID;
    }

    public void setConsumerId(String consumerId) {
        this.consumerID = consumerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFrontOfBuffer(MessageProxy proxy) throws Exception {
        Object object = this.mainLock;
        synchronized (object) {
            this.buffer.addFirst(proxy, proxy.getJMSPriority());
            this.messageAdded();
        }
    }

    public void synchronizeWith(ClientConsumer newHandler) {
        this.consumerID = newHandler.consumerID;
        this.buffer.clear();
        this.serverSending = true;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLastDelivery(long id) {
        if (trace) {
            log.trace((Object)("Waiting for last delivery id " + id));
        }
        if (id == -1L) {
            return;
        }
        Object object = this.mainLock;
        synchronized (object) {
            this.waitingForLastDelivery = true;
            try {
                long start;
                for (long wait = 30000L; this.lastDeliveryId != id && wait > 0L; wait -= System.currentTimeMillis() - start) {
                    start = System.currentTimeMillis();
                    try {
                        this.mainLock.wait(wait);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (trace && this.lastDeliveryId == id) {
                    log.trace((Object)"Got last delivery");
                }
                if (this.lastDeliveryId != id) {
                    log.warn((Object)("Timed out waiting for last delivery " + id + " got " + this.lastDeliveryId));
                }
            }
            finally {
                this.waitingForLastDelivery = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessageInternal(Object message) throws Exception {
        MessageProxy proxy = (MessageProxy)message;
        if (trace) {
            log.trace((Object)(this + " receiving message " + proxy + " from the remoting layer"));
        }
        Object object = this.mainLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(this + " is closed, so ignoring message");
            }
            proxy.setSessionDelegate(this.sessionDelegate, this.isConnectionConsumer);
            proxy.getMessage().doBeforeSend();
            this.buffer.addLast(proxy, proxy.getJMSPriority());
            this.lastDeliveryId = proxy.getDeliveryId();
            if (trace) {
                log.trace((Object)(this + " added message(s) to the buffer are now " + this.buffer.size() + " messages"));
            }
            this.messageAdded();
            if (this.handleFlowControl) {
                this.checkStop();
            }
        }
    }

    private void checkStop() {
        int size = this.buffer.size();
        if (this.serverSending && size >= this.maxBufferSize) {
            this.sendChangeRateMessage(0.0f);
            if (trace) {
                log.trace((Object)"Sent changeRate 0 message");
            }
            this.serverSending = false;
        }
    }

    private void checkStart() {
        int size = this.buffer.size();
        if (!this.serverSending && size <= this.minBufferSize) {
            this.sendChangeRateMessage(1.0f);
            if (trace) {
                log.trace((Object)"Sent changeRate 1.0 message");
            }
            this.serverSending = true;
        }
    }

    private void sendChangeRateMessage(float newRate) {
        try {
            this.consumerDelegate.changeRate(newRate);
        }
        catch (JMSException e) {
            log.error((Object)"Failed to send changeRate message", (Throwable)e);
        }
    }

    private void waitForOnMessageToComplete() {
        if (Thread.currentThread().equals(this.sessionExecutor.getThread())) {
            return;
        }
        Future result = new Future();
        try {
            this.sessionExecutor.execute((Runnable)new Closer(result));
            if (trace) {
                log.trace((Object)(this + " blocking wait for Closer execution"));
            }
            result.getResult();
            if (trace) {
                log.trace((Object)(this + " got Closer result"));
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)"Thread interrupted", (Throwable)e);
        }
    }

    private void queueRunner(ListenerRunner runner) {
        try {
            this.sessionExecutor.execute((Runnable)runner);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Thread interrupted", (Throwable)e);
        }
    }

    private void messageAdded() {
        boolean notified = false;
        if (trace) {
            log.trace((Object)("Receiver thread:" + this.receiverThread + " listener:" + this.listener + " listenerRunning:" + this.listenerRunning + " sessionExecutor:" + this.sessionExecutor));
        }
        if (this.receiverThread != null) {
            if (trace) {
                log.trace((Object)(this + " notifying receiver/waiter thread"));
            }
            this.mainLock.notifyAll();
            notified = true;
        } else if (this.listener != null && !this.listenerRunning) {
            this.listenerRunning = true;
            if (trace) {
                log.trace((Object)(this + " scheduled a new ListenerRunner"));
            }
            this.queueRunner(new ListenerRunner());
        }
        if (this.waitingForLastDelivery && !notified) {
            if (trace) {
                log.trace((Object)"Notifying");
            }
            this.mainLock.notifyAll();
        }
    }

    private long waitOnLock(Object lock, long waitTime) throws InterruptedException {
        long start = System.currentTimeMillis();
        lock.wait(waitTime);
        long waited = System.currentTimeMillis() - start;
        if (waited < waitTime) {
            return waitTime -= waited;
        }
        return 0L;
    }

    private MessageProxy getMessage(long timeout) {
        if (timeout != -1L) {
            try {
                if (timeout == 0L) {
                    while (!this.closed && this.buffer.isEmpty()) {
                        if (trace) {
                            log.trace((Object)(this + " waiting on main lock, no timeout"));
                        }
                        this.mainLock.wait();
                        if (!trace) continue;
                        log.trace((Object)(this + " done waiting on main lock"));
                    }
                } else {
                    long toWait = timeout;
                    while (!this.closed && this.buffer.isEmpty() && toWait > 0L) {
                        if (trace) {
                            log.trace((Object)(this + " waiting on main lock, timeout " + toWait + " ms"));
                        }
                        toWait = this.waitOnLock(this.mainLock, toWait);
                        if (!trace) continue;
                        log.trace((Object)(this + " done waiting on lock, buffer is " + (this.buffer.isEmpty() ? "" : "NOT ") + "empty"));
                    }
                }
            }
            catch (InterruptedException e) {
                if (trace) {
                    log.trace((Object)("InterruptedException, " + this + ".getMessage() returning null"));
                }
                return null;
            }
        }
        MessageProxy m = null;
        if (!this.closed && !this.buffer.isEmpty()) {
            m = (MessageProxy)this.buffer.removeFirst();
        }
        return m;
    }

    private class ListenerRunner
    implements Runnable {
        private ListenerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MessageProxy mp = null;
            MessageListener theListener = null;
            Object object = ClientConsumer.this.mainLock;
            synchronized (object) {
                if (ClientConsumer.this.listener == null || ClientConsumer.this.buffer.isEmpty()) {
                    ClientConsumer.this.listenerRunning = false;
                    if (trace) {
                        log.trace((Object)"no listener or buffer is empty, returning");
                    }
                    return;
                }
                theListener = ClientConsumer.this.listener;
                mp = (MessageProxy)ClientConsumer.this.buffer.removeFirst();
            }
            if (mp != null) {
                try {
                    ClientConsumer.callOnMessage(ClientConsumer.this.sessionDelegate, theListener, ClientConsumer.this.consumerID, ClientConsumer.this.queueName, false, mp, ClientConsumer.this.ackMode, ClientConsumer.this.maxDeliveries, null, ClientConsumer.this.shouldAck);
                    if (trace) {
                        log.trace((Object)"Called callonMessage");
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to deliver message", t);
                }
            }
            object = ClientConsumer.this.mainLock;
            synchronized (object) {
                if (!ClientConsumer.this.buffer.isEmpty()) {
                    if (trace) {
                        log.trace((Object)"More messages in buffer so queueing next onMessage to run");
                    }
                    ClientConsumer.this.queueRunner(this);
                    if (trace) {
                        log.trace((Object)"Queued next onMessage to run");
                    }
                } else {
                    if (trace) {
                        log.trace((Object)"no more messages in buffer, marking listener as not running");
                    }
                    ClientConsumer.this.listenerRunning = false;
                }
            }
            if (ClientConsumer.this.handleFlowControl) {
                ClientConsumer.this.checkStart();
            }
            if (trace) {
                log.trace((Object)"Exiting run()");
            }
        }
    }

    private class Closer
    implements Runnable {
        Future result;

        Closer(Future result) {
            this.result = result;
        }

        public void run() {
            if (trace) {
                log.trace((Object)"Closer starts running");
            }
            this.result.setResult(null);
            if (trace) {
                log.trace((Object)"Closer finished run");
            }
        }
    }
}

