/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.CompiledSetExpression;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.PropertyAccessor;
import org.mvel.ast.Assignment;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class DeepAssignmentNode
extends ASTNode
implements Assignment {
    private String property;
    private char[] stmt;
    private CompiledSetExpression set;
    private transient Accessor statement;

    public DeepAssignmentNode(char[] expr, int fields, int operation, String name) {
        super(expr, fields);
        if (operation != -1) {
            this.property = name.trim();
            this.stmt = ParseTools.createShortFormOperativeAssignment(this.property, expr, operation);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int mark = PropertyTools.find(expr, '=');
            if (mark != -1) {
                this.property = new String(expr, 0, mark).trim();
                this.stmt = ParseTools.subset(expr, mark + 1);
                if ((fields & 0x10) != 0) {
                    this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
                }
            } else {
                this.property = new String(expr);
            }
        }
        if ((fields & 0x10) != 0) {
            this.set = (CompiledSetExpression)MVEL.compileSetExpression(this.property.toCharArray());
        }
    }

    public DeepAssignmentNode(char[] expr, int fields) {
        this(expr, fields, -1, null);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            this.set = (CompiledSetExpression)MVEL.compileSetExpression(this.property.toCharArray());
        }
        Object val = this.statement.getValue(ctx, thisValue, factory);
        this.set.setValue(ctx, factory, val);
        return val;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object val = MVEL.eval(this.stmt, ctx, factory);
        PropertyAccessor.set(ctx, factory, this.property, val);
        return val;
    }

    public String getAssignmentVar() {
        return this.property;
    }
}

