/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.QName;

public class PropertyState
extends ItemState {
    static final long serialVersionUID = 90076676913237139L;
    private PropertyId id;
    private InternalValue[] values;
    private int type;
    private boolean multiValued;
    private PropDefId defId;

    public PropertyState(PropertyState overlayedState, int initialStatus, boolean isTransient) {
        super(overlayedState, initialStatus, isTransient);
        this.pull();
    }

    public PropertyState(PropertyId id, int initialStatus, boolean isTransient) {
        super(initialStatus, isTransient);
        this.id = id;
        this.type = 0;
        this.values = InternalValue.EMPTY_ARRAY;
        this.multiValued = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void copy(ItemState state) {
        ItemState itemState = state;
        synchronized (itemState) {
            PropertyState propState = (PropertyState)state;
            this.id = propState.id;
            this.type = propState.type;
            this.defId = propState.defId;
            this.values = propState.values;
            this.multiValued = propState.multiValued;
        }
    }

    public boolean isNode() {
        return false;
    }

    public ItemId getId() {
        return this.id;
    }

    public PropertyId getPropertyId() {
        return this.id;
    }

    public NodeId getParentId() {
        return this.id.getParentId();
    }

    public QName getName() {
        return this.id.getName();
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public int getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public PropDefId getDefinitionId() {
        return this.defId;
    }

    public void setDefinitionId(PropDefId defId) {
        this.defId = defId;
    }

    public void setValues(InternalValue[] values) {
        this.values = values;
    }

    public InternalValue[] getValues() {
        return this.values;
    }

    public long calculateMemoryFootprint() {
        return 350 + this.values.length * 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.id.toString());
        out.writeUTF(this.defId.toString());
        out.writeInt(this.type);
        out.writeBoolean(this.multiValued);
        if (this.values == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                InternalValue val = this.values[i];
                try {
                    if (this.type == 2) {
                        BLOBFileValue blob = (BLOBFileValue)val.internalValue();
                        InputStream in = blob.getStream();
                        out.writeLong(blob.getLength());
                        byte[] buf = new byte[8192];
                        try {
                            int read;
                            while ((read = in.read(buf)) > 0) {
                                out.write(buf, 0, read);
                            }
                            continue;
                        }
                        finally {
                            in.close();
                        }
                    }
                    out.writeUTF(val.toString());
                    continue;
                }
                catch (IllegalStateException ise) {
                    throw new IOException(ise.getMessage());
                }
                catch (RepositoryException re) {
                    throw new IOException(re.getMessage());
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.id = PropertyId.valueOf(in.readUTF());
        this.defId = PropDefId.valueOf(in.readUTF());
        this.type = in.readInt();
        this.multiValued = in.readBoolean();
        short count = in.readShort();
        if (count < 0) {
            this.values = null;
        } else {
            this.values = new InternalValue[count];
            for (int i = 0; i < this.values.length; ++i) {
                if (this.type == 2) {
                    final long length = in.readLong();
                    final ObjectInputStream stream = in;
                    this.values[i] = InternalValue.create(new InputStream(){
                        private long consumed = 0L;

                        public int read() throws IOException {
                            if (this.consumed >= length) {
                                return -1;
                            }
                            int b = stream.read();
                            ++this.consumed;
                            return b;
                        }

                        public int read(byte[] b, int off, int len) throws IOException {
                            if (this.consumed >= length) {
                                return -1;
                            }
                            if (this.consumed + (long)len > length) {
                                len = (int)(length - this.consumed);
                            }
                            int read = stream.read(b, off, len);
                            this.consumed += (long)read;
                            return read;
                        }

                        public long skip(long n) throws IOException {
                            if (this.consumed >= length && n > 0L) {
                                return -1L;
                            }
                            if (this.consumed + n > length) {
                                n = length - this.consumed;
                            }
                            long skipped = stream.skip(n);
                            this.consumed += skipped;
                            return skipped;
                        }

                        public void close() {
                        }
                    }, false);
                    continue;
                }
                this.values[i] = InternalValue.valueOf(in.readUTF(), this.type);
            }
        }
    }
}

