/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateReferenceMap;
import org.apache.jackrabbit.core.state.LRUItemStateCache;
import org.apache.jackrabbit.core.util.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStateReferenceCache
implements ItemStateCache,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)LRUItemStateCache.class);
    private final ItemStateReferenceMap refs;
    private final ItemStateCache cache;

    public ItemStateReferenceCache(ItemStateCacheFactory cacheFactory) {
        this(cacheFactory.newItemStateCache());
    }

    public ItemStateReferenceCache(ItemStateCache cache) {
        this.cache = cache;
        this.refs = new ItemStateReferenceMap();
    }

    public boolean isCached(ItemId id) {
        return this.refs.contains(id);
    }

    public ItemState retrieve(ItemId id) {
        this.cache.retrieve(id);
        return this.refs.get(id);
    }

    public void cache(ItemState state) {
        ItemId id = state.getId();
        if (this.refs.contains(id)) {
            log.warn("overwriting cached entry " + id);
        }
        this.cache.cache(state);
        this.refs.put(state);
    }

    public void evict(ItemId id) {
        this.cache.evict(id);
        this.refs.remove(id);
    }

    public void dispose() {
        this.cache.dispose();
    }

    public void evictAll() {
        this.cache.evictAll();
        this.refs.clear();
    }

    public void update(ItemId id) {
        this.cache.update(id);
    }

    public boolean isEmpty() {
        return this.refs.isEmpty();
    }

    public int size() {
        return this.refs.size();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.refs.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.refs.values());
    }

    public void dump(PrintStream ps) {
        ps.println("ItemStateReferenceCache (" + this + ")");
        ps.println();
        ps.print("[refs] ");
        this.refs.dump(ps);
    }
}

