/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.query.lucene.AbstractIndex;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VolatileIndex
extends AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger((Class)VolatileIndex.class);
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private final Map pending = new LinkedMap();
    private int bufferSize = 10;
    private int numDocs = 0;

    VolatileIndex(Analyzer analyzer) throws IOException {
        super(analyzer, (Directory)new RAMDirectory(), null);
    }

    void addDocument(Document doc) throws IOException {
        Document old = this.pending.put(doc.get(FieldNames.UUID), doc);
        if (old != null) {
            this.disposeDocument(old);
        }
        if (this.pending.size() >= this.bufferSize) {
            this.commitPending();
        }
        this.invalidateSharedReader();
        ++this.numDocs;
    }

    int removeDocument(Term idTerm) throws IOException {
        int num;
        Document doc = (Document)this.pending.remove(idTerm.text());
        if (doc != null) {
            this.disposeDocument(doc);
            num = 1;
        } else {
            num = super.getIndexReader().deleteDocuments(idTerm);
        }
        this.numDocs -= num;
        return num;
    }

    int getNumDocuments() throws IOException {
        return this.numDocs;
    }

    protected synchronized IndexReader getIndexReader() throws IOException {
        this.commitPending();
        return super.getIndexReader();
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        this.commitPending();
        super.commit(optimize);
    }

    void setBufferSize(int size) {
        this.bufferSize = size;
    }

    private void commitPending() throws IOException {
        Iterator it = this.pending.values().iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            super.addDocument(doc);
            it.remove();
        }
    }

    private void disposeDocument(Document old) {
        Enumeration e = old.fields();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (f.readerValue() == null) continue;
            try {
                f.readerValue().close();
            }
            catch (IOException ex) {
                log.warn("Exception while disposing index document: " + ex);
            }
        }
    }
}

