/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

class SharedIndexReader
extends FilterIndexReader {
    private boolean closeRequested = false;
    private final Map clients = new IdentityHashMap();

    public SharedIndexReader(CachingIndexReader in) {
        super((IndexReader)in);
    }

    public DocId getParent(int n, BitSet deleted) throws IOException {
        return this.getBase().getParent(n, deleted);
    }

    public synchronized void addClient(Object client) {
        this.clients.put(client, client);
    }

    public synchronized void removeClient(Object client) throws IOException {
        this.clients.remove(client);
        if (this.clients.isEmpty() && this.closeRequested) {
            super.doClose();
        }
    }

    protected synchronized void doClose() throws IOException {
        if (this.clients.isEmpty()) {
            super.doClose();
        } else {
            this.closeRequested = true;
        }
    }

    public TermDocs termDocs(Term term) throws IOException {
        return this.in.termDocs(term);
    }

    public CachingIndexReader getBase() {
        return (CachingIndexReader)this.in;
    }
}

