/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexMerger
extends Thread
implements IndexListener {
    private static final Logger log = LoggerFactory.getLogger((Class)IndexMerger.class);
    private static final Merge QUIT = new Merge(new Index[0]);
    private int minMergeDocs = 100;
    private int maxMergeDocs = 100000;
    private int mergeFactor = 10;
    private final Buffer mergeTasks = BufferUtils.blockingBuffer((Buffer)new UnboundedFifoBuffer());
    private final List deletedDocuments = Collections.synchronizedList(new ArrayList());
    private final List indexBuckets = new ArrayList();
    private final MultiIndex multiIndex;
    private final Object lock = new Object();
    private final Sync indexReplacement = new Mutex();

    IndexMerger(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
        this.setName("IndexMerger");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexAdded(String name, int numDocs) {
        if (numDocs < 0) {
            throw new IllegalArgumentException("numDocs must be positive");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.indexBuckets.size() == 0) {
                int lower = 0;
                for (int upper = this.minMergeDocs; upper < this.maxMergeDocs; upper *= this.mergeFactor) {
                    this.indexBuckets.add(new IndexBucket(lower, upper, true));
                    lower = upper + 1;
                }
                this.indexBuckets.add(new IndexBucket(lower, this.maxMergeDocs, false));
                this.indexBuckets.add(new IndexBucket(this.maxMergeDocs + 1, Integer.MAX_VALUE, false));
            }
            IndexBucket bucket = (IndexBucket)this.indexBuckets.get(this.indexBuckets.size() - 1);
            for (int i = 0; i < this.indexBuckets.size() && !(bucket = (IndexBucket)this.indexBuckets.get(i)).fits(numDocs); ++i) {
            }
            bucket.add(new Index(name, numDocs));
            if (log.isDebugEnabled()) {
                log.debug("index added: name=" + name + ", numDocs=" + numDocs);
            }
            if (!bucket.allowsMerge()) {
                return;
            }
            if (bucket.size() >= this.mergeFactor) {
                long targetMergeDocs = bucket.upper;
                targetMergeDocs = Math.min(targetMergeDocs * (long)this.mergeFactor, (long)this.maxMergeDocs);
                ArrayList indexesToMerge = new ArrayList();
                int mergeDocs = 0;
                Iterator it = bucket.iterator();
                while (it.hasNext() && (long)mergeDocs <= targetMergeDocs) {
                    indexesToMerge.add(it.next());
                }
                if (indexesToMerge.size() > 2) {
                    Index[] idxs = indexesToMerge.toArray(new Index[indexesToMerge.size()]);
                    bucket.removeAll(indexesToMerge);
                    if (log.isDebugEnabled()) {
                        log.debug("requesting merge for " + indexesToMerge);
                    }
                    this.mergeTasks.add((Object)new Merge(idxs));
                    log.debug("merge queue now contains " + this.mergeTasks.size() + " tasks.");
                }
            }
        }
    }

    public void documentDeleted(Term id) {
        log.debug("document deleted: " + id.text());
        this.deletedDocuments.add(id);
    }

    void dispose() {
        log.debug("dispose IndexMerger");
        try {
            this.indexReplacement.acquire();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while acquiring index replacement sync: " + e);
        }
        this.mergeTasks.clear();
        this.mergeTasks.add((Object)QUIT);
        log.debug("quit sent");
        try {
            this.join(500L);
            if (this.isAlive()) {
                log.info("Unable to stop IndexMerger. Deamon is busy.");
            } else {
                log.debug("IndexMerger thread stopped");
            }
            log.debug("merge queue size: " + this.mergeTasks.size());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for IndexMerger thread to terminate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Merge task;
        while ((task = (Merge)this.mergeTasks.remove()) != QUIT) {
            log.debug("accepted merge request");
            this.deletedDocuments.clear();
            String[] names = new String[task.indexes.length];
            for (int i = 0; i < task.indexes.length; ++i) {
                names[i] = task.indexes[i].name;
            }
            try {
                log.debug("create new index");
                PersistentIndex index = this.multiIndex.getOrCreateIndex(null, true);
                boolean success = false;
                try {
                    log.debug("get index readers from MultiIndex");
                    IndexReader[] readers = this.multiIndex.getIndexReaders(names, this);
                    try {
                        long time = System.currentTimeMillis();
                        index.addIndexes(readers);
                        time = System.currentTimeMillis() - time;
                        int docCount = 0;
                        for (int i = 0; i < readers.length; ++i) {
                            docCount += readers[i].numDocs();
                        }
                        log.info("merged " + docCount + " documents in " + time + " ms into " + index.getName() + ".");
                    }
                    finally {
                        for (int i = 0; i < readers.length; ++i) {
                            try {
                                readers[i].close();
                                continue;
                            }
                            catch (IOException e) {
                                log.warn("Unable to close IndexReader: " + e);
                            }
                        }
                    }
                    if (!this.indexReplacement.attempt(0L)) {
                        log.debug("index merging canceled");
                        break;
                    }
                    try {
                        log.debug("replace indexes");
                        this.multiIndex.replaceIndexes(names, index, this.deletedDocuments);
                    }
                    finally {
                        this.indexReplacement.release();
                    }
                    success = true;
                }
                finally {
                    if (success) continue;
                    log.debug("deleting index " + index.getName());
                    this.multiIndex.deleteIndex(index);
                }
            }
            catch (Throwable e) {
                log.error("Error while merging indexes: " + e);
            }
        }
        log.info("IndexMerger terminated");
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    private static final class IndexBucket
    extends ArrayList {
        private final int lower;
        private final int upper;
        private final boolean allowMerge;

        IndexBucket(int lower, int upper, boolean allowMerge) {
            this.lower = lower;
            this.upper = upper;
            this.allowMerge = allowMerge;
        }

        boolean fits(int numDocs) {
            return numDocs >= this.lower && numDocs <= this.upper;
        }

        boolean allowsMerge() {
            return this.allowMerge;
        }
    }

    private static final class Merge {
        private final Index[] indexes;

        Merge(Index[] indexes) {
            this.indexes = new Index[indexes.length];
            System.arraycopy(indexes, 0, this.indexes, 0, indexes.length);
        }
    }

    private static final class Index
    implements Comparable {
        private final String name;
        private final int numDocs;

        Index(String name, int numDocs) {
            this.name = name;
            this.numDocs = numDocs;
        }

        public int compareTo(Object o) {
            int val;
            Index other = (Index)o;
            int n = this.numDocs < other.numDocs ? -1 : (val = this.numDocs == other.numDocs ? 0 : 1);
            if (val != 0) {
                return val;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name + ":" + this.numDocs;
        }
    }
}

