/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.TransformConstants;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;

abstract class CaseTermQuery
extends MultiTermQuery
implements TransformConstants {
    protected final int transform;

    CaseTermQuery(Term term, int transform) {
        super(term);
        this.transform = transform;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseTermEnum(reader);
    }

    private final class CaseTermEnum
    extends FilteredTermEnum {
        private final int nameLength;
        private final OffsetCharSequence termText;
        private final OffsetCharSequence currentTerm;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CaseTermEnum(IndexReader reader) throws IOException {
            TermEnum terms;
            Iterator<Object> it;
            final LinkedHashMap<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
            Term term = CaseTermQuery.this.getTerm();
            ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
            this.nameLength = FieldNames.getNameLength(term.text());
            String propName = term.text().substring(0, this.nameLength);
            this.termText = new OffsetCharSequence(this.nameLength, term.text());
            this.currentTerm = new OffsetCharSequence(this.nameLength, term.text(), CaseTermQuery.this.transform);
            try {
                if (term.text().length() > this.nameLength) {
                    StringBuffer lowerLimit = new StringBuffer(propName);
                    lowerLimit.append(this.termText.toString().toUpperCase());
                    lowerLimit.setCharAt(this.nameLength, Character.toLowerCase(lowerLimit.charAt(this.nameLength)));
                    StringBuffer upperLimit = new StringBuffer(propName);
                    upperLimit.append(this.termText.toString().toLowerCase());
                    rangeScans.add(new RangeScan(reader, new Term(term.field(), lowerLimit.toString()), new Term(term.field(), upperLimit.toString())));
                    lowerLimit = new StringBuffer(propName);
                    lowerLimit.append(this.termText.toString().toUpperCase());
                    upperLimit = new StringBuffer(propName);
                    upperLimit.append(this.termText.toString().toLowerCase());
                    upperLimit.setCharAt(this.nameLength, Character.toUpperCase(upperLimit.charAt(this.nameLength)));
                    rangeScans.add(new RangeScan(reader, new Term(term.field(), lowerLimit.toString()), new Term(term.field(), upperLimit.toString())));
                } else {
                    rangeScans.add(new RangeScan(reader, term, term));
                }
                it = rangeScans.iterator();
                block7: while (it.hasNext()) {
                    Term t;
                    terms = (TermEnum)it.next();
                    while ((t = terms.term()) != null) {
                        this.currentTerm.setBase(t.text());
                        int compare = this.currentTerm.compareTo(this.termText);
                        if (compare == 0) {
                            orderedTerms.put(t, new Integer(terms.docFreq()));
                        } else if (compare < 0) {
                            // empty if block
                        }
                        if (terms.next()) continue;
                        continue block7;
                    }
                }
            }
            finally {
                it = rangeScans.iterator();
                while (it.hasNext()) {
                    terms = (TermEnum)it.next();
                    try {
                        terms.close();
                    }
                    catch (IOException e) {}
                }
            }
            it = orderedTerms.keySet().iterator();
            this.setEnum(new TermEnum(){
                private Term current;
                {
                    this.getNext();
                }

                public boolean next() {
                    this.getNext();
                    return this.current != null;
                }

                public Term term() {
                    return this.current;
                }

                public int docFreq() {
                    Integer docFreq = (Integer)orderedTerms.get(this.current);
                    return docFreq != null ? docFreq : 0;
                }

                public void close() {
                }

                private void getNext() {
                    this.current = it.hasNext() ? (Term)it.next() : null;
                }
            });
        }

        protected boolean termCompare(Term term) {
            return true;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return false;
        }
    }

    static final class Lower
    extends CaseTermQuery {
        Lower(Term term) {
            super(term, 1);
        }
    }

    static final class Upper
    extends CaseTermQuery {
        Upper(Term term) {
            super(term, 2);
        }
    }
}

