/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.compact;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;

public class CompactNodeTypeDefWriter {
    private static final String INDENT = "  ";
    private final NamespaceResolver resolver;
    private Writer out;
    private Writer nsWriter;
    private HashSet usedNamespaces = new HashSet();

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r) {
        this(out, r, false);
    }

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, boolean includeNS) {
        this.resolver = r;
        if (includeNS) {
            this.out = new StringWriter();
            this.nsWriter = out;
        } else {
            this.out = out;
            this.nsWriter = null;
        }
    }

    public static void write(List l, NamespaceResolver r, Writer out) throws IOException {
        CompactNodeTypeDefWriter w = new CompactNodeTypeDefWriter(out, r, true);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            NodeTypeDef def = (NodeTypeDef)iter.next();
            w.write(def);
        }
        w.close();
    }

    public void write(NodeTypeDef d) throws IOException {
        this.writeName(d);
        this.writeSupertypes(d);
        this.writeOptions(d);
        this.writePropDefs(d);
        this.writeNodeDefs(d);
        this.out.write("\n\n");
    }

    public void close() throws IOException {
        if (this.nsWriter != null) {
            this.nsWriter.write("\n");
            this.out.close();
            this.nsWriter.write(((StringWriter)this.out).getBuffer().toString());
            this.out = this.nsWriter;
            this.nsWriter = null;
        }
        this.out.flush();
        this.out = null;
    }

    private void writeName(NodeTypeDef ntd) throws IOException {
        this.out.write("[");
        this.out.write(this.resolve(ntd.getName()));
        this.out.write("]");
    }

    private void writeSupertypes(NodeTypeDef ntd) throws IOException {
        QName[] sta = ntd.getSupertypes();
        String delim = " > ";
        for (int i = 0; i < sta.length; ++i) {
            if (sta[i].equals((Object)QName.NT_BASE)) continue;
            this.out.write(delim);
            this.out.write(this.resolve(sta[i]));
            delim = ", ";
        }
    }

    private void writeOptions(NodeTypeDef ntd) throws IOException {
        if (ntd.hasOrderableChildNodes()) {
            this.out.write("\n  ");
            this.out.write("orderable");
            if (ntd.isMixin()) {
                this.out.write(" mixin");
            }
        } else if (ntd.isMixin()) {
            this.out.write("\n  ");
            this.out.write("mixin");
        }
    }

    private void writePropDefs(NodeTypeDef ntd) throws IOException {
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            PropDef pd = pda[i];
            this.writePropDef(ntd, pd);
        }
    }

    private void writeNodeDefs(NodeTypeDef ntd) throws IOException {
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            NodeDef nd = nda[i];
            this.writeNodeDef(ntd, nd);
        }
    }

    private void writePropDef(NodeTypeDef ntd, PropDef pd) throws IOException {
        this.out.write("\n  - ");
        this.writeItemDefName(pd.getName());
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue((int)pd.getRequiredType()).toLowerCase());
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValues());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals((Object)pd.getName()) ? " primary" : "");
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()).toLowerCase());
        }
        this.writeValueConstraints(pd.getValueConstraints());
    }

    private void writeDefaultValues(InternalValue[] dva) throws IOException {
        if (dva != null && dva.length > 0) {
            String delim = " = '";
            for (int i = 0; i < dva.length; ++i) {
                this.out.write(delim);
                try {
                    this.out.write(this.escape(dva[i].toJCRValue(this.resolver).getString()));
                }
                catch (RepositoryException e) {
                    this.out.write(this.escape(dva[i].toString()));
                }
                this.out.write("'");
                delim = ", '";
            }
        }
    }

    private void writeValueConstraints(ValueConstraint[] vca) throws IOException {
        if (vca != null && vca.length > 0) {
            String vc = vca[0].getDefinition(this.resolver);
            this.out.write("\n    < '");
            this.out.write(this.escape(vc));
            this.out.write("'");
            for (int i = 1; i < vca.length; ++i) {
                vc = vca[i].getDefinition(this.resolver);
                this.out.write(", '");
                this.out.write(this.escape(vc));
                this.out.write("'");
            }
        }
    }

    private void writeNodeDef(NodeTypeDef ntd, NodeDef nd) throws IOException {
        this.out.write("\n  + ");
        this.writeItemDefName(nd.getName());
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals((Object)nd.getName()) ? " primary" : "");
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeItemDefName(QName name) throws IOException {
        this.out.write(this.resolve(name));
    }

    private void writeRequiredTypes(QName[] reqTypes) throws IOException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (int i = 0; i < reqTypes.length; ++i) {
                this.out.write(delim);
                this.out.write(this.resolve(reqTypes[i]));
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(QName defType) throws IOException {
        if (defType != null && !defType.getLocalName().equals("*")) {
            this.out.write(" = ");
            this.out.write(this.resolve(defType));
        }
    }

    private String resolve(QName qname) throws IOException {
        if (qname == null) {
            return "";
        }
        try {
            String resolvedName;
            String prefix = this.resolver.getPrefix(qname.getNamespaceURI());
            if (prefix != null && !prefix.equals("")) {
                if (this.nsWriter != null && !this.usedNamespaces.contains(prefix)) {
                    this.usedNamespaces.add(prefix);
                    this.nsWriter.write("<'");
                    this.nsWriter.write(prefix);
                    this.nsWriter.write("'='");
                    this.nsWriter.write(this.escape(qname.getNamespaceURI()));
                    this.nsWriter.write("'>\n");
                }
                prefix = prefix + ":";
            }
            if ((resolvedName = prefix + qname.getLocalName()).indexOf(45) >= 0 || resolvedName.indexOf(43) >= 0) {
                return "'" + resolvedName + "'";
            }
            return resolvedName;
        }
        catch (NamespaceException e) {
            return qname.toString();
        }
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
                continue;
            }
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++i;
        }
        return sb.toString();
    }
}

