/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.core.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)PropertyDefinitionImpl.class);

    PropertyDefinitionImpl(PropDef propDef, NodeTypeManagerImpl ntMgr, NamespaceResolver nsResolver) {
        super(propDef, ntMgr, nsResolver);
    }

    public PropDef unwrap() {
        return (PropDef)this.itemDef;
    }

    public Value[] getDefaultValues() {
        InternalValue[] defVals = ((PropDef)this.itemDef).getDefaultValues();
        if (defVals == null) {
            return null;
        }
        Value[] values = new Value[defVals.length];
        for (int i = 0; i < defVals.length; ++i) {
            try {
                values[i] = defVals[i].toJCRValue(this.nsResolver);
                continue;
            }
            catch (RepositoryException re) {
                String propName = this.getName() == null ? "[null]" : this.getName();
                log.error("illegal default value specified for property " + propName + " in node type " + this.getDeclaringNodeType(), (Throwable)re);
                return null;
            }
        }
        return values;
    }

    public int getRequiredType() {
        return ((PropDef)this.itemDef).getRequiredType();
    }

    public String[] getValueConstraints() {
        ValueConstraint[] constraints = ((PropDef)this.itemDef).getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return new String[0];
        }
        String[] vca = new String[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            vca[i] = constraints[i].getDefinition(this.nsResolver);
        }
        return vca;
    }

    public boolean isMultiple() {
        return ((PropDef)this.itemDef).isMultiple();
    }
}

