/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ReferenceConstraint;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.name.QName;

public class NodeTypeDef
implements Cloneable {
    private QName name = null;
    private QName[] supertypes;
    private boolean mixin = false;
    private boolean orderableChildNodes = false;
    private QName primaryItemName = null;
    private HashSet propDefs;
    private HashSet nodeDefs = new HashSet();
    private Set dependencies = null;

    public NodeTypeDef() {
        this.propDefs = new HashSet();
        this.supertypes = QName.EMPTY_ARRAY;
    }

    public Collection getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet();
            this.dependencies.addAll(Arrays.asList(this.supertypes));
            Iterator iter = this.nodeDefs.iterator();
            while (iter.hasNext()) {
                NodeDef nd = (NodeDef)iter.next();
                QName ntName = nd.getDefaultPrimaryType();
                if (ntName != null && !this.name.equals((Object)ntName)) {
                    this.dependencies.add(ntName);
                }
                QName[] ntNames = nd.getRequiredPrimaryTypes();
                for (int j = 0; j < ntNames.length; ++j) {
                    if (ntNames[j] == null || this.name.equals((Object)ntNames[j])) continue;
                    this.dependencies.add(ntNames[j]);
                }
            }
            iter = this.propDefs.iterator();
            while (iter.hasNext()) {
                ValueConstraint[] ca;
                PropDef pd = (PropDef)iter.next();
                if (pd.getRequiredType() != 9 || (ca = pd.getValueConstraints()) == null) continue;
                for (int j = 0; j < ca.length; ++j) {
                    ReferenceConstraint rc = (ReferenceConstraint)ca[j];
                    if (this.name.equals((Object)rc.getNodeTypeName())) continue;
                    this.dependencies.add(rc.getNodeTypeName());
                }
            }
        }
        return this.dependencies;
    }

    private void resetDependencies() {
        this.dependencies = null;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setSupertypes(QName[] names) {
        this.resetDependencies();
        if (names.length == 0) {
            this.supertypes = QName.EMPTY_ARRAY;
        } else if (names.length == 1) {
            this.supertypes = new QName[]{names[0]};
        } else {
            TreeSet<QName> types = new TreeSet<QName>();
            types.addAll(Arrays.asList(names));
            this.supertypes = types.toArray(new QName[types.size()]);
        }
    }

    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    public void setOrderableChildNodes(boolean orderableChildNodes) {
        this.orderableChildNodes = orderableChildNodes;
    }

    public void setPrimaryItemName(QName primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    public void setPropertyDefs(PropDef[] defs) {
        this.resetDependencies();
        this.propDefs.clear();
        this.propDefs.addAll(Arrays.asList(defs));
    }

    public void setChildNodeDefs(NodeDef[] defs) {
        this.resetDependencies();
        this.nodeDefs.clear();
        this.nodeDefs.addAll(Arrays.asList(defs));
    }

    public QName getName() {
        return this.name;
    }

    public QName[] getSupertypes() {
        if (this.supertypes.length > 0 || this.isMixin() || QName.NT_BASE.equals((Object)this.getName())) {
            return this.supertypes;
        }
        return new QName[]{QName.NT_BASE};
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public QName getPrimaryItemName() {
        return this.primaryItemName;
    }

    public PropDef[] getPropertyDefs() {
        if (this.propDefs.isEmpty()) {
            return PropDef.EMPTY_ARRAY;
        }
        return this.propDefs.toArray(new PropDef[this.propDefs.size()]);
    }

    public NodeDef[] getChildNodeDefs() {
        if (this.nodeDefs.isEmpty()) {
            return NodeDef.EMPTY_ARRAY;
        }
        return this.nodeDefs.toArray(new NodeDef[this.nodeDefs.size()]);
    }

    public Object clone() {
        NodeTypeDef clone = new NodeTypeDef();
        clone.name = this.name;
        clone.primaryItemName = this.primaryItemName;
        clone.supertypes = this.supertypes;
        clone.mixin = this.mixin;
        clone.orderableChildNodes = this.orderableChildNodes;
        clone.nodeDefs = (HashSet)this.nodeDefs.clone();
        clone.propDefs = (HashSet)this.propDefs.clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeTypeDef) {
            NodeTypeDef other = (NodeTypeDef)obj;
            return (this.name == null ? other.name == null : this.name.equals((Object)other.name)) && (this.primaryItemName == null ? other.primaryItemName == null : this.primaryItemName.equals((Object)other.primaryItemName)) && Arrays.equals(this.getSupertypes(), other.getSupertypes()) && this.mixin == other.mixin && this.orderableChildNodes == other.orderableChildNodes && this.propDefs.equals(other.propDefs) && this.nodeDefs.equals(other.nodeDefs);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

