/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Session;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.ClusterSession;
import org.apache.jackrabbit.core.cluster.FileRecord;
import org.apache.jackrabbit.core.cluster.FileRecordCursor;
import org.apache.jackrabbit.core.cluster.FileRecordInput;
import org.apache.jackrabbit.core.cluster.FileRecordLog;
import org.apache.jackrabbit.core.cluster.FileRecordOutput;
import org.apache.jackrabbit.core.cluster.FileRevision;
import org.apache.jackrabbit.core.cluster.Journal;
import org.apache.jackrabbit.core.cluster.JournalException;
import org.apache.jackrabbit.core.cluster.NodeAddedOperation;
import org.apache.jackrabbit.core.cluster.NodeDeletedOperation;
import org.apache.jackrabbit.core.cluster.NodeModifiedOperation;
import org.apache.jackrabbit.core.cluster.NodeOperation;
import org.apache.jackrabbit.core.cluster.PropertyAddedOperation;
import org.apache.jackrabbit.core.cluster.PropertyDeletedOperation;
import org.apache.jackrabbit.core.cluster.PropertyModifiedOperation;
import org.apache.jackrabbit.core.cluster.PropertyOperation;
import org.apache.jackrabbit.core.cluster.RecordProcessor;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJournal
implements Journal {
    private static final String REVISION_NAME = "revision";
    private static final String LOG_EXTENSION = "log";
    private static final String DEFAULT_BASENAME = "journal";
    private static final int DEFAULT_MAXSIZE = 0x100000;
    private static Logger log = LoggerFactory.getLogger((Class)FileJournal.class);
    private String id;
    private NamespaceResolver resolver;
    private RecordProcessor processor;
    private String directory;
    private String revision;
    private String basename;
    private int maximumSize;
    private File root;
    private File journal;
    private FileRevision instanceRevision;
    private FileRevision globalRevision;
    private final Mutex writeMutex = new Mutex();
    private File tempLog;
    private FileRecordOutput out;
    private FileRecord record;
    private Session lastSession;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void init(String id, RecordProcessor processor, NamespaceResolver resolver) throws JournalException {
        this.id = id;
        this.resolver = resolver;
        this.processor = processor;
        if (this.directory == null) {
            String msg = "Directory not specified.";
            throw new JournalException(msg);
        }
        if (this.revision == null) {
            String msg = "Revision not specified.";
            throw new JournalException(msg);
        }
        if (this.basename == null) {
            this.basename = DEFAULT_BASENAME;
        }
        if (this.maximumSize == 0) {
            this.maximumSize = 0x100000;
        }
        this.root = new File(this.directory);
        if (!this.root.exists() || !this.root.isDirectory()) {
            String msg = "Directory specified does either not exist or is not a directory: " + this.directory;
            throw new JournalException(msg);
        }
        this.journal = new File(this.root, this.basename + "." + LOG_EXTENSION);
        this.instanceRevision = new FileRevision(new File(this.revision));
        this.globalRevision = new FileRevision(new File(this.root, REVISION_NAME));
        log.info("FileJournal initialized at path: " + this.directory);
    }

    public void sync() throws JournalException {
        File[] logFiles = this.root.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(FileJournal.this.basename + ".");
            }
        });
        Arrays.sort(logFiles, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f1.compareTo(f2);
            }
        });
        long instanceValue = this.instanceRevision.get();
        long globalValue = this.globalRevision.get();
        if (instanceValue < globalValue) {
            FileRecordCursor cursor = new FileRecordCursor(logFiles, instanceValue, globalValue);
            try {
                while (cursor.hasNext()) {
                    FileRecord record = cursor.next();
                    if (!record.getCreator().equals(this.id)) {
                        this.process(record);
                    } else {
                        log.info("Log entry matches journal id, skipped: " + record.getRevision());
                    }
                    this.instanceRevision.set(record.getNextRevision());
                }
            }
            catch (IOException e) {
                String msg = "Unable to iterate over modified records: " + e.getMessage();
                throw new JournalException(msg, e);
            }
            finally {
                try {
                    cursor.close();
                }
                catch (IOException e) {
                    String msg = "I/O error while closing record cursor: " + e.getMessage();
                    log.warn(msg);
                }
            }
            log.info("Sync finished, instance revision is: " + this.instanceRevision.get());
        }
    }

    void process(FileRecord record) throws JournalException {
        log.info("Processing revision: " + record.getRevision());
        FileRecordInput in = record.getInput(this.resolver);
        String workspace = null;
        try {
            char c;
            workspace = in.readString();
            this.processor.start(workspace);
            while ((c = in.readChar()) != '\u0000') {
                if (c == 'N') {
                    NodeOperation operation = NodeOperation.create(in.readByte());
                    operation.setId(in.readNodeId());
                    this.processor.process(operation);
                    continue;
                }
                if (c == 'P') {
                    PropertyOperation operation = PropertyOperation.create(in.readByte());
                    operation.setId(in.readPropertyId());
                    this.processor.process(operation);
                    continue;
                }
                if (c == 'E') {
                    byte type = in.readByte();
                    NodeId parentId = in.readNodeId();
                    Path parentPath = in.readPath();
                    NodeId childId = in.readNodeId();
                    Path.PathElement childRelPath = in.readPathElement();
                    QName ntName = in.readQName();
                    HashSet<QName> mixins = new HashSet<QName>();
                    int mixinCount = in.readInt();
                    for (int i = 0; i < mixinCount; ++i) {
                        mixins.add(in.readQName());
                    }
                    String userId = in.readString();
                    this.processor.process(this.createEventState(type, parentId, parentPath, childId, childRelPath, ntName, mixins, userId));
                    continue;
                }
                if (c == 'L') {
                    NodeId nodeId = in.readNodeId();
                    boolean isLock = in.readBoolean();
                    if (isLock) {
                        boolean isDeep = in.readBoolean();
                        String owner = in.readString();
                        this.processor.process(nodeId, isDeep, owner);
                        continue;
                    }
                    this.processor.process(nodeId);
                    continue;
                }
                if (c == 'S') {
                    String oldPrefix = in.readString();
                    String newPrefix = in.readString();
                    String uri = in.readString();
                    this.processor.process(oldPrefix, newPrefix, uri);
                    continue;
                }
                if (c == 'T') {
                    int size = in.readInt();
                    HashSet<NodeTypeDef> ntDefs = new HashSet<NodeTypeDef>();
                    for (int i = 0; i < size; ++i) {
                        ntDefs.add(in.readNodeTypeDef());
                    }
                    this.processor.process(ntDefs);
                    continue;
                }
                throw new IllegalArgumentException("Unknown entry type: " + c);
            }
            this.processor.end();
        }
        catch (NameException e) {
            String msg = "Unable to read revision " + record.getRevision() + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        catch (ParseException e) {
            String msg = "Unable to read revision " + record.getRevision() + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        catch (IOException e) {
            String msg = "Unable to read revision " + record.getRevision() + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "Error while processing revision " + record.getRevision() + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        finally {
            in.close();
        }
    }

    public void begin(String workspace) throws JournalException {
        try {
            this.writeMutex.acquire();
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while waiting for write lock.";
            throw new JournalException(msg);
        }
        boolean succeeded = false;
        try {
            this.sync();
            this.tempLog = File.createTempFile(DEFAULT_BASENAME, ".tmp", this.root);
            this.record = new FileRecord(this.id, this.tempLog);
            this.out = this.record.getOutput(this.resolver);
            this.out.writeString(workspace);
            succeeded = true;
        }
        catch (IOException e) {
            String msg = "Unable to create journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        finally {
            if (!succeeded) {
                this.writeMutex.release();
            }
        }
    }

    public void log(ChangeLog changeLog, EventStateCollection esc) throws JournalException {
        Iterator addedStates = changeLog.addedStates();
        while (addedStates.hasNext()) {
            ItemState state = (ItemState)addedStates.next();
            if (state.isNode()) {
                this.log(NodeAddedOperation.create((NodeState)state));
                continue;
            }
            this.log(PropertyAddedOperation.create((PropertyState)state));
        }
        Iterator modifiedStates = changeLog.modifiedStates();
        while (modifiedStates.hasNext()) {
            ItemState state = (ItemState)modifiedStates.next();
            if (state.isNode()) {
                this.log(NodeModifiedOperation.create((NodeState)state));
                continue;
            }
            this.log(PropertyModifiedOperation.create((PropertyState)state));
        }
        Iterator deletedStates = changeLog.deletedStates();
        while (deletedStates.hasNext()) {
            ItemState state = (ItemState)deletedStates.next();
            if (state.isNode()) {
                this.log(NodeDeletedOperation.create((NodeState)state));
                continue;
            }
            this.log(PropertyDeletedOperation.create((PropertyState)state));
        }
        Iterator events = esc.getEvents().iterator();
        while (events.hasNext()) {
            EventState event = (EventState)events.next();
            this.log(event);
        }
    }

    public void log(String oldPrefix, String newPrefix, String uri) throws JournalException {
        try {
            this.out.writeChar('S');
            this.out.writeString(oldPrefix);
            this.out.writeString(newPrefix);
            this.out.writeString(uri);
        }
        catch (IOException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
    }

    public void log(NodeId nodeId, boolean isDeep, String owner) throws JournalException {
        this.log(nodeId, true, isDeep, owner);
    }

    public void log(NodeId nodeId) throws JournalException {
        this.log(nodeId, false, false, null);
    }

    public void log(Collection ntDefs) throws JournalException {
        try {
            this.out.writeChar('T');
            this.out.writeInt(ntDefs.size());
            Iterator iter = ntDefs.iterator();
            while (iter.hasNext()) {
                this.out.writeNodeTypeDef((NodeTypeDef)iter.next());
            }
        }
        catch (IOException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
    }

    protected void log(PropertyOperation operation) throws JournalException {
        try {
            this.out.writeChar('P');
            this.out.writeByte(operation.getOperationType());
            this.out.writePropertyId(operation.getId());
        }
        catch (NoPrefixDeclaredException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        catch (IOException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
    }

    protected void log(NodeOperation operation) throws JournalException {
        try {
            this.out.writeChar('N');
            this.out.writeByte(operation.getOperationType());
            this.out.writeNodeId(operation.getId());
        }
        catch (IOException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
    }

    protected void log(EventState event) throws JournalException {
        try {
            this.out.writeChar('E');
            this.out.writeByte(event.getType());
            this.out.writeNodeId(event.getParentId());
            this.out.writePath(event.getParentPath());
            this.out.writeNodeId(event.getChildId());
            this.out.writePathElement(event.getChildRelPath());
            this.out.writeQName(event.getNodeType());
            Set mixins = event.getMixinNames();
            this.out.writeInt(mixins.size());
            Iterator iter = mixins.iterator();
            while (iter.hasNext()) {
                this.out.writeQName((QName)iter.next());
            }
            this.out.writeString(event.getUserId());
        }
        catch (NoPrefixDeclaredException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        catch (IOException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
    }

    protected void log(NodeId nodeId, boolean isLock, boolean isDeep, String owner) throws JournalException {
        try {
            this.out.writeChar('L');
            this.out.writeNodeId(nodeId);
            this.out.writeBoolean(isLock);
            if (isLock) {
                this.out.writeBoolean(isDeep);
                this.out.writeString(owner);
            }
        }
        catch (IOException e) {
            String msg = "Unable to write to journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws JournalException {
        this.globalRevision.lock(false);
        boolean prepared = false;
        try {
            this.sync();
            this.record.setRevision(this.globalRevision.get());
            prepared = true;
        }
        finally {
            if (!prepared) {
                this.globalRevision.unlock();
                this.writeMutex.release();
            }
        }
    }

    public void commit() throws JournalException {
        try {
            this.out.writeChar('\u0000');
            this.out.close();
            long nextRevision = this.record.getNextRevision();
            FileRecordLog recordLog = new FileRecordLog(this.journal);
            if (!recordLog.isNew() && nextRevision - recordLog.getFirstRevision() > (long)this.maximumSize) {
                this.switchLogs();
                recordLog = new FileRecordLog(this.journal);
            }
            recordLog.append(this.record);
            this.tempLog.delete();
            this.globalRevision.set(nextRevision);
            this.instanceRevision.set(nextRevision);
        }
        catch (IOException e) {
            String msg = "Unable to close journal log " + this.tempLog + ": " + e.getMessage();
            throw new JournalException(msg);
        }
        finally {
            this.out = null;
            this.globalRevision.unlock();
            this.writeMutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.out != null) {
            try {
                this.out.close();
                this.tempLog.delete();
            }
            catch (IOException e) {
                String msg = "Unable to close journal log " + this.tempLog + ": " + e.getMessage();
                log.warn(msg);
            }
            finally {
                this.out = null;
                this.globalRevision.unlock();
                this.writeMutex.release();
            }
        }
    }

    public void close() {
    }

    protected EventState createEventState(int type, NodeId parentId, Path parentPath, NodeId childId, Path.PathElement childRelPath, QName ntName, Set mixins, String userId) {
        switch (type) {
            case 1: {
                return EventState.childNodeAdded(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId));
            }
            case 2: {
                return EventState.childNodeRemoved(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId));
            }
            case 4: {
                return EventState.propertyAdded(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId));
            }
            case 16: {
                return EventState.propertyChanged(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId));
            }
            case 8: {
                return EventState.propertyRemoved(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId));
            }
        }
        String msg = "Unexpected event type: " + type;
        throw new IllegalArgumentException(msg);
    }

    protected Session getOrCreateSession(String userId) {
        if (this.lastSession == null || !this.lastSession.getUserID().equals(userId)) {
            this.lastSession = new ClusterSession(userId);
        }
        return this.lastSession;
    }

    private void switchLogs() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(FileJournal.this.basename + ".");
            }
        };
        File[] files = this.root.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f2.compareTo(f1);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            int sep = name.lastIndexOf(46);
            if (sep == -1) continue;
            String ext = name.substring(sep + 1);
            if (ext.equals(LOG_EXTENSION)) {
                file.renameTo(new File(this.root, name + ".1"));
                continue;
            }
            try {
                int version = Integer.parseInt(ext);
                String newName = name.substring(0, sep + 1) + String.valueOf(version + 1);
                file.renameTo(new File(newName));
                continue;
            }
            catch (NumberFormatException e) {
                log.warn("Bogusly named journal file, skipped: " + file);
            }
        }
    }
}

