/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.name.AbstractNamespaceResolver;
import org.apache.jackrabbit.name.NameCache;
import org.apache.jackrabbit.name.NamespaceListener;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.XMLChar;

class LocalNamespaceMappings
extends AbstractNamespaceResolver
implements NamespaceListener,
NameCache {
    private final NamespaceRegistryImpl nsReg;
    private final HashMap prefixToURI = new HashMap();
    private final HashMap uriToPrefix = new HashMap();

    LocalNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
        this.nsReg.addListener(this);
    }

    void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("prefix/uri can not be null");
        }
        if ("".equals(prefix) || "".equals(uri)) {
            throw new NamespaceException("default namespace is reserved and can not be changed");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceException("xml namespace is reserved and can not be changed.");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("reserved prefix: " + prefix);
        }
        if (!XMLChar.isValidNCName((String)prefix)) {
            throw new NamespaceException("invalid prefix: " + prefix);
        }
        this.nsReg.getPrefix(uri);
        if (Arrays.asList(this.getPrefixes()).contains(prefix)) {
            if (this.getURI(prefix).equals(uri)) {
                return;
            }
            throw new NamespaceException("prefix already in use: " + prefix);
        }
        String oldPrefix = (String)this.uriToPrefix.get(uri);
        if (oldPrefix != null) {
            this.uriToPrefix.remove(uri);
            this.prefixToURI.remove(oldPrefix);
        }
        this.prefixToURI.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    String[] getPrefixes() throws RepositoryException {
        if (this.prefixToURI.isEmpty()) {
            return this.nsReg.getPrefixes();
        }
        HashSet<String> prefixes = new HashSet<String>();
        String[] uris = this.nsReg.getURIs();
        for (int i = 0; i < uris.length; ++i) {
            String prefix = (String)this.uriToPrefix.get(uris[i]);
            if (prefix == null) {
                prefix = this.nsReg.getPrefix(uris[i]);
            }
            prefixes.add(prefix);
        }
        return prefixes.toArray(new String[prefixes.size()]);
    }

    void dispose() {
        this.nsReg.removeListener(this);
    }

    public QName retrieveName(String jcrName) {
        if (this.prefixToURI.size() == 0) {
            return this.nsReg.retrieveName(jcrName);
        }
        return null;
    }

    public String retrieveName(QName name) {
        if (this.prefixToURI.size() == 0 || !this.uriToPrefix.containsKey(name.getNamespaceURI())) {
            return this.nsReg.retrieveName(name);
        }
        return null;
    }

    public void cacheName(String jcrName, QName name) {
        if (this.prefixToURI.size() == 0 || !this.uriToPrefix.containsKey(name.getNamespaceURI())) {
            this.nsReg.cacheName(jcrName, name);
        }
    }

    public void evictAllNames() {
        this.nsReg.evictAllNames();
    }

    public String getURI(String prefix) throws NamespaceException {
        if (this.prefixToURI.isEmpty()) {
            return this.nsReg.getURI(prefix);
        }
        String uri = (String)this.prefixToURI.get(prefix);
        if (uri != null) {
            return uri;
        }
        uri = this.nsReg.getURI(prefix);
        if (uri != null && !this.uriToPrefix.containsKey(uri)) {
            return uri;
        }
        throw new NamespaceException(prefix + ": unknown prefix");
    }

    public String getPrefix(String uri) throws NamespaceException {
        if (this.prefixToURI.isEmpty()) {
            return this.nsReg.getPrefix(uri);
        }
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix != null) {
            return prefix;
        }
        return this.nsReg.getPrefix(uri);
    }

    public void namespaceAdded(String prefix, String uri) {
        if (this.prefixToURI.containsKey(prefix)) {
            String uniquePrefix = prefix + "_";
            while (this.prefixToURI.containsKey(uniquePrefix)) {
                uniquePrefix = uniquePrefix + "_";
            }
            this.prefixToURI.put(uniquePrefix, uri);
            this.uriToPrefix.put(uri, uniquePrefix);
        }
    }

    public void namespaceRemapped(String oldPrefix, String newPrefix, String uri) {
        if (this.prefixToURI.containsKey(newPrefix)) {
            if (this.uriToPrefix.containsKey(uri)) {
                return;
            }
            String uniquePrefix = newPrefix + "_";
            while (this.prefixToURI.containsKey(uniquePrefix)) {
                uniquePrefix = uniquePrefix + "_";
            }
            this.prefixToURI.put(uniquePrefix, uri);
            this.uriToPrefix.put(uri, uniquePrefix);
        }
    }

    public void namespaceRemoved(String uri) {
        if (this.uriToPrefix.containsKey(uri)) {
            String prefix = (String)this.uriToPrefix.remove(uri);
            this.prefixToURI.remove(prefix);
        }
    }
}

