/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class DefaultPermissionStorage
implements PermissionStorage {
    private static final String CONDPERMS = "condPerms";
    protected File permissionDir;
    protected Hashtable permissionFiles;
    protected File defaultData;
    protected static final int PERMISSIONDATA_VERSION_1 = 1;
    protected static final int PERMISSIONDATA_VERSION = 1;

    public DefaultPermissionStorage(AbstractFrameworkAdaptor adaptor) throws IOException {
        this.permissionDir = new File(adaptor.getBundleStoreRootDir(), "permdata");
        this.permissionFiles = new Hashtable();
        if (!this.permissionDir.exists() && !this.permissionDir.mkdirs()) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unable to create directory: " + this.permissionDir.getPath());
            }
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, this.permissionDir));
        }
        this.defaultData = new File(this.permissionDir, ".default");
        this.loadLocations();
    }

    public synchronized String[] getLocations() throws IOException {
        int size = this.permissionFiles.size();
        if (size == 0) {
            return null;
        }
        String[] locations = new String[size];
        Enumeration keysEnum = this.permissionFiles.keys();
        for (int i = 0; i < size; ++i) {
            locations[i] = (String)keysEnum.nextElement();
        }
        return locations;
    }

    public synchronized String[] getPermissionData(String location) throws IOException {
        File file;
        if (location == null) {
            file = this.defaultData;
        } else {
            file = (File)this.permissionFiles.get(location);
            if (file == null) {
                return null;
            }
        }
        try {
            return this.readData(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public synchronized void setPermissionData(String location, String[] data) throws IOException {
        if (location == null) {
            File file = this.defaultData;
            if (data == null) {
                ReliableFile.delete(this.defaultData);
            } else {
                this.save(this.defaultData, null, data);
            }
        } else {
            File file = (File)this.permissionFiles.get(location);
            if (data == null) {
                if (file == null) {
                    return;
                }
                this.permissionFiles.remove(location);
                ReliableFile.delete(file);
            } else {
                file = this.save(file, location, data);
                this.permissionFiles.put(location, file);
            }
        }
    }

    protected void loadLocations() throws IOException {
        String[] list = ReliableFile.getBaseFiles(this.permissionDir);
        if (list == null) {
            return;
        }
        for (String name : list) {
            if (name.endsWith(".tmp") || name.equals(CONDPERMS)) continue;
            File file = new File(this.permissionDir, name);
            try {
                String location = this.readLocation(file);
                if (location == null) continue;
                this.permissionFiles.put(location, file);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLocation(File file) throws IOException {
        DataInputStream in = new DataInputStream(new ReliableFileInputStream(file));
        try {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    boolean locationPresent = in.readBoolean();
                    if (locationPresent) {
                        String location;
                        String string = location = in.readUTF();
                        return string;
                    }
                    break;
                }
                default: {
                    throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
                }
            }
        }
        finally {
            in.close();
        }
        return null;
    }

    private String[] readData(File file) throws IOException {
        DataInputStream in = new DataInputStream(new ReliableFileInputStream(file));
        try {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    boolean locationPresent = in.readBoolean();
                    if (locationPresent) {
                        String location = in.readUTF();
                    }
                    int size = in.readInt();
                    String[] data = new String[size];
                    for (int i = 0; i < size; ++i) {
                        data[i] = in.readUTF();
                    }
                    String[] stringArray = data;
                    return stringArray;
                }
            }
            throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File save(File file, String location, String[] data) throws IOException {
        if (file == null) {
            file = File.createTempFile("perm", "", this.permissionDir);
            file.delete();
        }
        int size = data.length;
        DataOutputStream out = new DataOutputStream(new ReliableFileOutputStream(file));
        try {
            out.writeInt(1);
            if (location == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(location);
            }
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                out.writeUTF(data[i]);
            }
        }
        finally {
            out.close();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeConditionalPermissionInfos(Vector v) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(this.permissionDir, CONDPERMS))));
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                int i;
                ConditionalPermissionInfo cpi = (ConditionalPermissionInfo)en.nextElement();
                ConditionInfo[] cis = cpi.getConditionInfos();
                PermissionInfo[] pis = cpi.getPermissionInfos();
                for (i = 0; i < cis.length; ++i) {
                    writer.write(cis[i].getEncoded());
                    writer.newLine();
                }
                for (i = 0; i < pis.length; ++i) {
                    writer.write(pis[i].getEncoded());
                    writer.newLine();
                }
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public Vector deserializeConditionalPermissionInfos() throws IOException {
        BufferedReader reader = null;
        Vector<ConditionalPermissionInfoImpl> v = new Vector<ConditionalPermissionInfoImpl>(15);
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.permissionDir, CONDPERMS))));
            Vector<ConditionInfo> c = new Vector<ConditionInfo>(3);
            Vector<PermissionInfo> p = new Vector<PermissionInfo>(3);
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) {
                    ConditionalPermissionInfoImpl cpi = new ConditionalPermissionInfoImpl(c.toArray(new ConditionInfo[0]), p.toArray(new PermissionInfo[0]));
                    v.add(cpi);
                    c.clear();
                    p.clear();
                    continue;
                }
                if (line.startsWith("(")) {
                    p.add(new PermissionInfo(line));
                    continue;
                }
                if (!line.startsWith("[")) continue;
                c.add(new ConditionInfo(line));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return v;
    }
}

