/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleURLConnection;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundleResourceHandler
extends URLStreamHandler {
    public static final String SECURITY_AUTHORIZED = "SECURITY_AUTHORIZED";
    protected static BundleContext context;
    protected BundleEntry bundleEntry;

    public BundleResourceHandler() {
        this(null);
    }

    public BundleResourceHandler(BundleEntry bundleEntry) {
        this.bundleEntry = bundleEntry;
    }

    protected void parseURL(URL url, String str, int start, int end) {
        int dotIndex;
        if (end < start) {
            return;
        }
        if (url.getPath() != null) {
            this.bundleEntry = null;
        }
        String spec = "";
        if (start < end) {
            spec = str.substring(start, end);
        }
        end -= start;
        String path = url.getPath();
        String bundleId = url.getHost();
        int resIndex = 0;
        int pathIdx = 0;
        if (spec.startsWith("//")) {
            int bundleIdEnd;
            int bundleIdIdx = 2;
            pathIdx = spec.indexOf(47, bundleIdIdx);
            if (pathIdx == -1) {
                pathIdx = end;
                path = "";
            }
            if ((bundleIdEnd = spec.indexOf(58, bundleIdIdx)) > pathIdx || bundleIdEnd == -1) {
                bundleIdEnd = pathIdx;
            }
            if (bundleIdEnd < pathIdx - 1) {
                try {
                    resIndex = Integer.parseInt(spec.substring(bundleIdEnd + 1, pathIdx));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            bundleId = spec.substring(bundleIdIdx, bundleIdEnd);
        }
        if (pathIdx < end && spec.charAt(pathIdx) == '/') {
            path = spec.substring(pathIdx, end);
        } else if (end > pathIdx) {
            int last;
            if (path == null || path.equals("")) {
                path = "/";
            }
            path = (last = path.lastIndexOf(47) + 1) == 0 ? spec.substring(pathIdx, end) : path.substring(0, last) + spec.substring(pathIdx, end);
        }
        if (path == null) {
            path = "";
        }
        while ((dotIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, dotIndex + 1) + path.substring(dotIndex + 3);
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((dotIndex = path.indexOf("/../")) >= 0) {
            if (dotIndex != 0) {
                path = path.substring(0, path.lastIndexOf(47, dotIndex - 1)) + path.substring(dotIndex + 3);
                continue;
            }
            path = path.substring(dotIndex + 3);
        }
        if (path.endsWith("/..") && path.length() > 3) {
            path = path.substring(0, path.length() - 2);
        }
        this.checkAdminPermission(context.getBundle(Long.parseLong(bundleId)));
        this.setURL(url, url.getProtocol(), bundleId, resIndex, SECURITY_AUTHORIZED, null, path, null, null);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        long bundleID;
        if (this.bundleEntry != null) {
            return new BundleURLConnection(url, this.bundleEntry);
        }
        String bidString = url.getHost();
        if (bidString == null) {
            throw new IOException(NLS.bind(AdaptorMsg.URL_NO_BUNDLE_ID, url.toExternalForm()));
        }
        AbstractBundle bundle = null;
        try {
            bundleID = Long.parseLong(bidString);
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException(NLS.bind(AdaptorMsg.URL_INVALID_BUNDLE_ID, bidString));
        }
        bundle = (AbstractBundle)context.getBundle(bundleID);
        if (!url.getAuthority().equals(SECURITY_AUTHORIZED)) {
            this.checkAdminPermission(bundle);
        }
        if (bundle == null) {
            throw new IOException(NLS.bind(AdaptorMsg.URL_NO_BUNDLE_FOUND, url.toExternalForm()));
        }
        return new BundleURLConnection(url, this.findBundleEntry(url, bundle));
    }

    protected abstract BundleEntry findBundleEntry(URL var1, AbstractBundle var2) throws IOException;

    protected String toExternalForm(URL url) {
        String path;
        int index;
        StringBuffer result = new StringBuffer(url.getProtocol());
        result.append("://");
        String bundleId = url.getHost();
        if (bundleId != null && bundleId.length() > 0) {
            result.append(bundleId);
        }
        if ((index = url.getPort()) > 0) {
            result.append(':').append(index);
        }
        if ((path = url.getPath()) != null) {
            if (path.length() > 0 && path.charAt(0) != '/') {
                result.append("/");
            }
            result.append(path);
        }
        return result.toString();
    }

    public static void setContext(BundleContext context) {
        BundleResourceHandler.context = context;
    }

    protected int hashCode(URL url) {
        String path;
        String host;
        int hash = 0;
        String protocol = url.getProtocol();
        if (protocol != null) {
            hash += protocol.hashCode();
        }
        if ((host = url.getHost()) != null) {
            hash += host.hashCode();
        }
        if ((path = url.getPath()) != null) {
            hash += path.hashCode();
        }
        return hash;
    }

    protected boolean equals(URL url1, URL url2) {
        return this.sameFile(url1, url2);
    }

    protected synchronized InetAddress getHostAddress(URL url) {
        return null;
    }

    protected boolean hostsEqual(URL url1, URL url2) {
        String host1 = url1.getHost();
        String host2 = url2.getHost();
        if (host1 != null && host2 != null) {
            return host1.equalsIgnoreCase(host2);
        }
        return host1 == null && host2 == null;
    }

    protected boolean sameFile(URL url1, URL url2) {
        String path2;
        String a2;
        String p2;
        String p1 = url1.getProtocol();
        if (!(p1 == (p2 = url2.getProtocol()) || p1 != null && p1.equalsIgnoreCase(p2))) {
            return false;
        }
        if (!this.hostsEqual(url1, url2)) {
            return false;
        }
        if (url1.getPort() != url2.getPort()) {
            return false;
        }
        String a1 = url1.getAuthority();
        if (!(a1 == (a2 = url2.getAuthority()) || a1 != null && a1.equals(a2))) {
            return false;
        }
        String path1 = url1.getPath();
        return path1 == (path2 = url2.getPath()) || path1 != null && path1.equals(path2);
    }

    protected void checkAdminPermission(Bundle bundle) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, "resource"));
        }
    }

    protected static BundleClassLoader getBundleClassLoader(AbstractBundle bundle) {
        BundleLoader loader = bundle.getBundleLoader();
        if (loader == null) {
            return null;
        }
        return loader.createClassLoader();
    }
}

