/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class IfStatement
extends Statement {
    private Block ifBlock;
    private Block elseBlock;
    private Criteria condition;

    public IfStatement() {
    }

    public IfStatement(Criteria criteria, Block ifBlock, Block elseBlock) {
        this.ifBlock = ifBlock;
        this.elseBlock = elseBlock;
        this.condition = criteria;
    }

    public IfStatement(Criteria criteria, Block ifBlock) {
        this(criteria, ifBlock, null);
    }

    public Block getIfBlock() {
        return this.ifBlock;
    }

    public void setIfBlock(Block block) {
        this.ifBlock = block;
    }

    public Block getElseBlock() {
        return this.elseBlock;
    }

    public void setElseBlock(Block block) {
        this.elseBlock = block;
    }

    public boolean hasElseBlock() {
        return this.elseBlock != null;
    }

    public Criteria getCondition() {
        return this.condition;
    }

    public void setCondition(Criteria criteria) {
        this.condition = criteria;
    }

    public int getType() {
        return 1;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Block otherIf = (Block)this.ifBlock.clone();
        Criteria otherCrit = (Criteria)this.condition.clone();
        Block otherElse = null;
        if (this.hasElseBlock()) {
            otherElse = (Block)this.elseBlock.clone();
        }
        return new IfStatement(otherCrit, otherIf, otherElse);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IfStatement other = (IfStatement)obj;
        return EquivalenceUtil.areEqual(this.getCondition(), other.getCondition()) && EquivalenceUtil.areEqual(this.getIfBlock(), other.getIfBlock()) && EquivalenceUtil.areEqual(this.getElseBlock(), other.getElseBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.getCondition());
        myHash = HashCodeUtil.hashCode(myHash, this.getIfBlock());
        myHash = HashCodeUtil.hashCode(myHash, this.getElseBlock());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

