/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.MetaBasePermission;
import com.metamatrix.platform.security.api.MetaBaseResource;
import java.io.Serializable;

public class MetaBasePermissionFactory
implements AuthorizationPermissionFactory,
Serializable {
    private static final String REALM_NAME = "MetaBase";
    private static final AuthorizationRealm REALM = new AuthorizationRealm("MetaBase");

    public Class getPermissionClass() {
        return MetaBasePermission.class;
    }

    public AuthorizationResource createResource(String path) {
        return new MetaBaseResource(path);
    }

    public AuthorizationPermission create(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String contentModifier) {
        String factoryClassName = this.getClass().getName();
        return new MetaBasePermission(resource, REALM, actions, contentModifier, factoryClassName);
    }

    public AuthorizationPermission create(String resource, AuthorizationRealm realm) {
        return new MetaBasePermission(new MetaBaseResource(resource), REALM, this.getClass().getName());
    }

    public AuthorizationPermission create(String resource, AuthorizationRealm realm, AuthorizationActions actions) {
        return new MetaBasePermission(new MetaBaseResource(resource), REALM, actions, this.getClass().getName());
    }

    public static String getRealmName() {
        return REALM_NAME;
    }

    public static AuthorizationRealm getRealm() {
        return REALM;
    }

    static {
        REALM.setDescription("The MetaBase authorization realm.");
    }
}

