/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.xa.MMXid;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMXAConnection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MMXAResource
implements XAResource {
    private MMXAConnection mmConnection;
    private int timeOut;

    public static MMXAResource newInstance(MMXAConnection mmConnection) {
        if (AOP.useproxy()) {
            return (MMXAResource)ProxyFactory.extend(MMXAResource.class, new Class[]{MMXAConnection.class}, new Object[]{mmConnection});
        }
        return new MMXAResource(mmConnection);
    }

    public MMXAResource(MMXAConnection mmConnection) {
        this.mmConnection = mmConnection;
    }

    public Logger getLogger() {
        return this.mmConnection.getLogger();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().commitTransaction(mmXid, onePhase);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedCommitTXN", xid, onePhase ? "true" : "false");
            throw this.handleError(e, logMsg);
        }
    }

    private XAException handleError(Exception e, String logMsg) {
        this.getLogger().log(2, e, logMsg);
        if (e instanceof MMSQLException) {
            Throwable ex = ((MMSQLException)e).getNestedException();
            if (ex instanceof XAException) {
                return (XAException)ex;
            }
            if (ex instanceof XATransactionException) {
                return ((XATransactionException)ex).getXAException();
            }
        }
        return new XAException(-3);
    }

    public void end(Xid xid, int flag) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().endTransaction(mmXid, flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedEndTXN", xid, new Integer(flag));
            throw this.handleError(e, logMsg);
        }
    }

    public void forget(Xid xid) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().forgetTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedForgetTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeOut;
    }

    public boolean isSameRM(XAResource arg0) throws XAException {
        ServerInstance siOther;
        ServerInstance si;
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof MMXAResource)) {
            return false;
        }
        MMXAResource other = (MMXAResource)arg0;
        try {
            si = this.mmConnection.getMMConnection().getServerConnection().selectServerInstance(null);
            siOther = other.getMMConnection().getServerConnection().selectServerInstance(null);
        }
        catch (CommunicationException e) {
            throw this.handleError(e, JDBCPlugin.Util.getString("MMXAResource.FailedISSameRM"));
        }
        catch (SQLException e) {
            throw this.handleError(e, JDBCPlugin.Util.getString("MMXAResource.FailedISSameRM"));
        }
        if (!(si instanceof SocketServerInstance)) {
            return !(siOther instanceof SocketServerInstance);
        }
        if (!(siOther instanceof SocketServerInstance)) {
            return false;
        }
        HostInfo host = ((SocketServerInstance)si).getHostInfo();
        HostInfo otherHost = ((SocketServerInstance)siOther).getHostInfo();
        return host.getHostName().equals(otherHost.getHostName()) && host.getPortNumber() == otherHost.getPortNumber();
    }

    public int prepare(Xid xid) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            return this.getMMConnection().prepareTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedPrepareTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return this.getMMConnection().recoverTransaction(flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRecoverTXN", flag);
            throw this.handleError(e, logMsg);
        }
    }

    public void rollback(Xid xid) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().rollbackTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRollbackTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.timeOut = seconds;
        return true;
    }

    public void start(Xid xid, int flag) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        this.getLogger().log(5, "MMXAResource - start:\nXid: " + xid + "\nMM Xid: " + mmXid);
        try {
            this.getMMConnection().startTransaction(mmXid, flag, this.timeOut);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedStartTXN", xid, new Integer(flag));
            this.handleError(e, logMsg);
        }
    }

    private MMConnection getMMConnection() throws XAException {
        try {
            return this.mmConnection.getMMConnection();
        }
        catch (SQLException e) {
            throw new XAException(-7);
        }
    }

    private MMXid getMMXid(Xid originalXid) throws XAException {
        return new MMXid(originalXid);
    }
}

