/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.factory;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.FileUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ComponentLoader {
    private Object interpreter;
    private Method evalMethod;
    private Method setMethod;
    private Method setClassLoaderMethod;

    public ComponentLoader(ClassLoader classLoader, String scriptName) {
        this.init(classLoader, scriptName);
    }

    private void init(ClassLoader classLoader, String scriptName) {
        InputStream scriptStream = classLoader.getResourceAsStream(scriptName);
        if (scriptStream == null) {
            throw new MetaMatrixRuntimeException(CorePlugin.Util.getString("ComponentLoader.Resource_not_found__{0}_1", scriptName));
        }
        InputStreamReader scriptReader = new InputStreamReader(scriptStream);
        String script = FileUtil.read(scriptReader);
        try {
            Class<?> interpreterClass = classLoader.loadClass("bsh.Interpreter");
            this.interpreter = interpreterClass.newInstance();
            this.initMethods();
            this.execute(this.setClassLoaderMethod, new Object[]{classLoader});
            this.execute(script);
        }
        catch (ClassNotFoundException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private void initMethods() {
        try {
            this.evalMethod = this.interpreter.getClass().getMethod("eval", String.class);
            this.setMethod = this.interpreter.getClass().getMethod("set", String.class, Object.class);
            this.setClassLoaderMethod = this.interpreter.getClass().getMethod("setClassLoader", ClassLoader.class);
        }
        catch (SecurityException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    public void set(String name, Object value) {
        this.execute(this.setMethod, new Object[]{name, value});
    }

    public Object execute(String command) {
        return this.execute(this.evalMethod, new Object[]{command});
    }

    private Object execute(Method method, Object[] args) {
        try {
            return method.invoke(this.interpreter, args);
        }
        catch (IllegalAccessException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
    }

    public Object load(String name) {
        return this.execute("load" + name + "()");
    }
}

