/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.common.types.basic.AnyToStringTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;

public class ClobToStringTransform
extends AnyToStringTransform {
    public Object transform(Object value) throws TransformationException {
        if (value == null) {
            return value;
        }
        ClobType source = (ClobType)value;
        try {
            BufferedReader reader = new BufferedReader(source.getCharacterStream());
            StringBuffer contents = new StringBuffer();
            int chr = reader.read();
            while (chr != -1 && contents.length() < 4000) {
                contents.append((char)chr);
                chr = reader.read();
            }
            reader.close();
            return contents.toString();
        }
        catch (SQLException e) {
            throw new TransformationException(e, CommonPlugin.Util.getString("failed_convert", new Object[]{this.getSourceType().getName(), this.getTargetType().getName()}));
        }
        catch (IOException e) {
            throw new TransformationException(e, CommonPlugin.Util.getString("failed_convert", new Object[]{this.getSourceType().getName(), this.getTargetType().getName()}));
        }
        catch (InvalidReferenceException e) {
            throw new TransformationException(e, CommonPlugin.Util.getString("remote_lob_access"));
        }
    }

    public Class getSourceType() {
        return ClobType.class;
    }

    public boolean isNarrowing() {
        return true;
    }
}

