/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.osgi.service.condpermadmin.Condition;

public class FrameworkSecurityManager
extends SecurityManager {
    ThreadLocal localCheckContext = new ThreadLocal();
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$FrameworkSecurityManager$CheckPermissionAction;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$FrameworkSecurityManager$CheckContext;

    boolean addConditionsForDomain(Condition[][] condSet) {
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc == null) {
            return false;
        }
        if (cc.depth > 0) {
            return false;
        }
        if (cc.condSets == null) {
            cc.condSets = new Vector();
        }
        cc.condSets.add(condSet);
        return true;
    }

    public void checkPermission(Permission perm, Object context) {
        AccessController.doPrivileged(new CheckPermissionAction(this, perm, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCheckPermission(Permission perm, Object context) {
        AccessControlContext acc = (AccessControlContext)context;
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc != null) {
            ++cc.depth;
        } else {
            cc = new CheckContext();
            this.localCheckContext.set(cc);
        }
        try {
            acc.checkPermission(perm);
            if (cc.depth == 0 && cc.condSets != null) {
                Hashtable condContextDict = new Hashtable(2);
                boolean passed = false;
                Condition[][] conds = (Condition[][])cc.condSets.get(0);
                cc.condSets.removeElementAt(0);
                for (int i = 0; i < conds.length && !passed; ++i) {
                    passed = this.recursiveCheck(cc.condSets, conds[i], new Hashtable(2), condContextDict);
                }
                if (!passed) {
                    throw new SecurityException("Conditions not satisfied");
                }
            }
        }
        finally {
            if (cc.depth == 0) {
                this.localCheckContext.set(null);
            }
            --cc.depth;
        }
    }

    private boolean recursiveCheck(Vector remainingSets, Condition[] conditions, Hashtable condDict, Hashtable condContextDict) {
        for (int i = 0; i < conditions.length; ++i) {
            if (conditions[i] == null) continue;
            Vector<Condition> condList = (Vector<Condition>)condDict.get(conditions[i].getClass());
            if (condList == null) {
                condList = new Vector<Condition>();
                condDict.put(conditions[i].getClass(), condList);
            }
            condList.add(conditions[i]);
        }
        if (remainingSets.size() > 0) {
            boolean passed = false;
            Condition[][] conds = (Condition[][])remainingSets.get(0);
            Vector newSets = (Vector)remainingSets.clone();
            newSets.remove(0);
            for (int i = 0; i < conds.length; ++i) {
                passed = this.recursiveCheck(newSets, conds[i], (Hashtable)condDict.clone(), condContextDict);
                if (!passed) continue;
                return true;
            }
            return false;
        }
        Enumeration keys = condDict.keys();
        while (keys.hasMoreElements()) {
            Class key = (Class)keys.nextElement();
            Vector conds = (Vector)condDict.get(key);
            if (conds.size() == 0) continue;
            Condition[] condArray = conds.toArray(new Condition[0]);
            Hashtable context = (Hashtable)condContextDict.get(key);
            if (context == null) {
                context = new Hashtable(2);
                condContextDict.put(key, context);
            }
            if (condArray[0].isSatisfied(condArray, context)) continue;
            return false;
        }
        return true;
    }

    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$org$eclipse$osgi$framework$internal$core$FrameworkSecurityManager$CheckPermissionAction;
        if (clazz2 == null) {
            Class<?> c;
            clazz2 = c = (class$org$eclipse$osgi$framework$internal$core$FrameworkSecurityManager$CheckPermissionAction = new CheckPermissionAction[0].getClass().getComponentType());
        }
        if ((clazz = class$org$eclipse$osgi$framework$internal$core$FrameworkSecurityManager$CheckContext) == null) {
            clazz = class$org$eclipse$osgi$framework$internal$core$FrameworkSecurityManager$CheckContext = new CheckContext[0].getClass().getComponentType();
        }
        Class<?> clazz3 = clazz;
    }

    static class CheckPermissionAction
    implements PrivilegedAction {
        Permission perm;
        Object context;
        FrameworkSecurityManager fsm;

        CheckPermissionAction(FrameworkSecurityManager fsm, Permission perm, Object context) {
            this.fsm = fsm;
            this.perm = perm;
            this.context = context;
        }

        public Object run() {
            this.fsm.internalCheckPermission(this.perm, this.context);
            return null;
        }
    }

    static class CheckContext {
        int depth;
        Vector condSets;

        CheckContext() {
        }
    }
}

