/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionSet
extends PermissionCollection {
    private static final long serialVersionUID = 3258411750729920566L;
    ConditionalPermissionInfoImpl[] cpis = new ConditionalPermissionInfoImpl[0];
    HashMap cachedPermissionCollections = new HashMap();
    private boolean hasAllPermission = false;
    Condition[] neededConditions;
    static /* synthetic */ Class class$java$security$AllPermission;

    public ConditionalPermissionSet(ConditionalPermissionInfoImpl[] cpis, Condition[] neededConditions) {
        this.cpis = cpis;
        this.neededConditions = neededConditions;
        this.checkForAllPermission();
    }

    void addConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        if (this.neededConditions.length > 0) {
            throw new RuntimeException("Cannot add ConditionalPermissionInfoImpl to a non satisfied set");
        }
        ConditionalPermissionInfoImpl[] newcpis = new ConditionalPermissionInfoImpl[this.cpis.length + 1];
        System.arraycopy(this.cpis, 0, newcpis, 0, this.cpis.length);
        newcpis[this.cpis.length] = cpi;
        this.cpis = newcpis;
        this.cachedPermissionCollections.clear();
        this.checkForAllPermission();
    }

    private void checkForAllPermission() {
        if (this.hasAllPermission) {
            return;
        }
        block0: for (int i = 0; i < this.cpis.length; ++i) {
            PermissionInfo[] perms = this.cpis[i].perms;
            for (int j = 0; j < perms.length; ++j) {
                String string = perms[j].getType();
                Class<?> clazz = class$java$security$AllPermission;
                if (clazz == null) {
                    clazz = new AllPermission[0].getClass().getComponentType();
                }
                if (!string.equals(clazz.getName())) continue;
                this.hasAllPermission = true;
                break block0;
            }
        }
    }

    boolean isNonEmpty() {
        boolean nonEmpty = false;
        for (int i = 0; i < this.cpis.length; ++i) {
            if (this.cpis[i] == null) continue;
            if (this.cpis[i].isDeleted()) {
                this.cpis[i] = null;
                this.cachedPermissionCollections.clear();
                continue;
            }
            nonEmpty = true;
        }
        if (!nonEmpty) {
            this.cpis = new ConditionalPermissionInfoImpl[0];
        }
        return nonEmpty;
    }

    Condition[] getNeededConditions() {
        if (this.neededConditions == null || this.neededConditions.length == 0) {
            return this.neededConditions;
        }
        boolean foundNonNullCondition = false;
        for (int i = 0; i < this.neededConditions.length; ++i) {
            Condition cond = this.neededConditions[i];
            if (cond == null) continue;
            if (!cond.isMutable()) {
                if (cond.isSatisfied()) {
                    this.neededConditions[i] = null;
                    continue;
                }
                this.neededConditions = null;
                break;
            }
            foundNonNullCondition = true;
        }
        if (this.neededConditions != null && !foundNonNullCondition) {
            this.neededConditions = new Condition[0];
        }
        return this.neededConditions;
    }

    public void add(Permission perm) {
    }

    public boolean implies(Permission perm) {
        if (this.hasAllPermission) {
            return true;
        }
        Class<?> permClass = perm.getClass();
        PermissionCollection collection = (PermissionCollection)this.cachedPermissionCollections.get(permClass);
        if (collection == null) {
            collection = perm.newPermissionCollection();
            if (collection == null) {
                collection = new PermissionsHash();
            }
            for (int i = 0; i < this.cpis.length; ++i) {
                try {
                    ConditionalPermissionInfoImpl cpi = this.cpis[i];
                    if (cpi == null) continue;
                    cpi.addPermissions(collection, permClass);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.cachedPermissionCollections.put(permClass, collection);
        }
        return collection.implies(perm);
    }

    public Enumeration elements() {
        return null;
    }

    void unresolvePermissions(AbstractBundle[] refreshedBundles) {
        this.cachedPermissionCollections.clear();
    }
}

