/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.framework.adaptor.core.BundleInstaller;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.resolver.ReadOnlyState;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class StateManager
implements PlatformAdmin,
Runnable {
    public static boolean DEBUG = false;
    public static boolean DEBUG_READER = false;
    public static boolean DEBUG_PLATFORM_ADMIN = false;
    public static boolean DEBUG_PLATFORM_ADMIN_RESOLVER = false;
    public static boolean MONITOR_PLATFORM_ADMIN = false;
    public static String PROP_NO_LAZY_LOADING = "osgi.noLazyStateLoading";
    public static String PROP_LAZY_UNLOADING_TIME = "osgi.lazyStateUnloadingTime";
    private long expireTime = 300000L;
    private long readStartupTime;
    private StateImpl systemState;
    private StateObjectFactoryImpl factory;
    private long lastTimeStamp;
    private BundleInstaller installer;
    private boolean cachedState = false;
    private File stateFile;
    private File lazyFile;
    private long expectedTimeStamp;
    private BundleContext context;

    public StateManager(File stateFile, File lazyFile, BundleContext context) {
        this(stateFile, lazyFile, context, -1L);
    }

    public StateManager(File stateFile, File lazyFile, BundleContext context, long expectedTimeStamp) {
        this.stateFile = stateFile;
        this.lazyFile = lazyFile;
        this.context = context;
        this.expectedTimeStamp = expectedTimeStamp;
        this.factory = new StateObjectFactoryImpl();
    }

    public void shutdown(File stateFile, File lazyFile) throws IOException {
        BundleDescription[] removalPendings = this.systemState.getRemovalPendings();
        if (removalPendings.length > 0) {
            this.systemState.resolve(removalPendings);
        }
        this.writeState(stateFile, lazyFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSystemState(File stateFile, File lazyFile, long expectedTimeStamp) {
        if (stateFile == null || !stateFile.isFile()) {
            return;
        }
        if (DEBUG_READER) {
            this.readStartupTime = System.currentTimeMillis();
        }
        try {
            boolean lazyLoad = Boolean.valueOf(System.getProperty(PROP_NO_LAZY_LOADING)) == false;
            this.systemState = this.factory.readSystemState(stateFile, lazyFile, lazyLoad, expectedTimeStamp);
            if (this.systemState == null || !this.initializeSystemState()) {
                this.systemState = null;
                return;
            }
            this.cachedState = true;
            try {
                this.expireTime = Long.parseLong(System.getProperty(PROP_LAZY_UNLOADING_TIME, Long.toString(this.expireTime)));
            }
            catch (NumberFormatException nfe) {
                this.expireTime = 0L;
            }
            if (lazyLoad && this.expireTime > 0L) {
                Thread t = new Thread((Runnable)this, "State Data Manager");
                t.setDaemon(true);
                t.start();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (DEBUG_READER) {
                System.out.println("Time to read state: " + (System.currentTimeMillis() - this.readStartupTime));
            }
        }
    }

    private void writeState(File stateFile, File lazyFile) throws IOException {
        if (this.systemState == null) {
            return;
        }
        if (this.cachedState && this.lastTimeStamp == this.systemState.getTimeStamp()) {
            return;
        }
        this.systemState.fullyLoad();
        this.factory.writeState(this.systemState, stateFile, lazyFile);
    }

    private boolean initializeSystemState() {
        this.systemState.setResolver(this.getResolver(System.getSecurityManager() != null));
        this.lastTimeStamp = this.systemState.getTimeStamp();
        return !this.systemState.setPlatformProperties(System.getProperties());
    }

    public synchronized State createSystemState() {
        if (this.systemState == null) {
            this.systemState = this.factory.createSystemState();
            this.initializeSystemState();
        }
        return this.systemState;
    }

    public synchronized State readSystemState() {
        if (this.systemState == null) {
            this.readSystemState(this.stateFile, this.lazyFile, this.expectedTimeStamp);
        }
        return this.systemState;
    }

    public State getSystemState() {
        return this.systemState;
    }

    public long getCachedTimeStamp() {
        return this.lastTimeStamp;
    }

    public State getState(boolean mutable) {
        return mutable ? this.factory.createState(this.systemState) : new ReadOnlyState(this.systemState);
    }

    public State getState() {
        return this.getState(true);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public synchronized void commit(State state) throws BundleException {
        if (this.installer == null) {
            throw new IllegalArgumentException("PlatformAdmin.commit() not supported");
        }
        if (!(state instanceof UserState)) {
            throw new IllegalArgumentException("Wrong state implementation");
        }
        if (state.getTimeStamp() != this.systemState.getTimeStamp()) {
            throw new BundleException(StateMsg.COMMIT_INVALID_TIMESTAMP);
        }
        StateDelta delta = state.compare(this.systemState);
        BundleDelta[] changes = delta.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            if ((changes[i].getType() & 1) > 0) {
                this.installer.installBundle(changes[i].getBundle());
                continue;
            }
            if ((changes[i].getType() & 2) > 0) {
                this.installer.uninstallBundle(changes[i].getBundle());
                continue;
            }
            if ((changes[i].getType() & 4) <= 0) continue;
            this.installer.updateBundle(changes[i].getBundle());
        }
    }

    public Resolver getResolver() {
        return this.getResolver(false);
    }

    private Resolver getResolver(boolean checkPermissions) {
        return new ResolverImpl(this.context, checkPermissions);
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    public BundleInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(BundleInstaller installer) {
        this.installer = installer;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.expireTime);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.systemState == null || this.lastTimeStamp != this.systemState.getTimeStamp()) continue;
            this.systemState.unloadLazyData(this.expireTime);
        }
    }
}

