/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.adaptor.core.SignedBundle;
import org.eclipse.osgi.framework.adaptor.core.SignedBundleSupport;
import org.eclipse.osgi.framework.adaptor.core.StateManager;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleResourceHandler;
import org.eclipse.osgi.framework.internal.core.DefaultPermissionStorage;
import org.eclipse.osgi.framework.internal.core.ReferenceInputStream;
import org.eclipse.osgi.framework.internal.core.ServiceRegistryImpl;
import org.eclipse.osgi.framework.internal.core.SystemBundleData;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractFrameworkAdaptor
implements FrameworkAdaptor {
    public static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    public static final String PROP_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    public static final String PROP_SIGNINGSUPPORT = "osgi.bundlesigning.support";
    public static final String PARENT_CLASSLOADER_APP = "app";
    public static final String PARENT_CLASSLOADER_EXT = "ext";
    public static final String PARENT_CLASSLOADER_BOOT = "boot";
    public static final String PARENT_CLASSLOADER_FWK = "fwk";
    public static final String BUNDLEFILE_NAME = "bundlefile";
    public static final byte EXTENSION_INITIALIZE = 1;
    public static final byte EXTENSION_INSTALLED = 2;
    public static final byte EXTENSION_UNINSTALLED = 4;
    public static final byte EXTENSION_UPDATED = 8;
    protected final String ADAPTOR_MANIFEST = "ADAPTOR.MF";
    protected final String DEFAULT_SIGNEDBUNDLE_SUPPORT = "org.eclipse.osgi.framework.pkcs7verify.SignedBundleSupportImpl";
    protected EventPublisher eventPublisher;
    protected ServiceRegistry serviceRegistry;
    protected Properties properties;
    protected BundleContext context;
    protected int initialBundleStartLevel = 1;
    protected Headers manifest = null;
    protected boolean stopping = false;
    protected static ClassLoader bundleClassLoaderParent;
    protected long nextId = 1L;
    protected StateManager stateManager;
    protected File bundleStoreRootDir;
    protected AdaptorElementFactory elementFactory;
    protected Method addURLMethod;
    protected String[] configuredExtensions;
    protected boolean supportSignedBundles = true;
    protected SignedBundleSupport signedBundleSupport = null;
    protected FrameworkLog frameworkLog;
    public static final String BUNDLE_STORE = "osgi.bundlestore";
    protected String bundleStore = null;
    protected PermissionStorage permissionStore;
    protected boolean reset = false;
    protected File dataRootDir;
    public static final String DATA_DIR_NAME = "data";
    protected boolean invalidState = false;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor;

    public AbstractFrameworkAdaptor(String[] args) {
        ClassLoader fwloader;
        Class<?> clazz = class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor;
        if (clazz == null) {
            clazz = class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor = new AbstractFrameworkAdaptor[0].getClass().getComponentType();
        }
        if ((fwloader = clazz.getClassLoader()) != null) {
            this.addURLMethod = AbstractFrameworkAdaptor.findaddURLMethod(fwloader.getClass());
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String key;
                StringTokenizer tok;
                String arg = args[i];
                if (arg.equalsIgnoreCase("reset")) {
                    this.reset = true;
                    continue;
                }
                if (arg.indexOf("=") == -1 || (tok = new StringTokenizer(args[i], "=")).countTokens() != 2 || !(key = tok.nextToken()).equalsIgnoreCase("bundledir")) continue;
                this.bundleStore = tok.nextToken();
            }
        }
    }

    public void initialize(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.serviceRegistry = new ServiceRegistryImpl();
        ((ServiceRegistryImpl)this.serviceRegistry).initialize();
        this.loadProperties();
        this.readAdaptorManifest();
        this.initBundleStoreRootDir();
        this.frameworkLog = this.createFrameworkLog();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public abstract AdaptorElementFactory getElementFactory();

    protected abstract void persistNextBundleID(long var1) throws IOException;

    public FrameworkLog getFrameworkLog() {
        if (this.frameworkLog == null) {
            this.frameworkLog = this.createFrameworkLog();
        }
        return this.frameworkLog;
    }

    public State getState() {
        return this.stateManager.getSystemState();
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.stateManager;
    }

    public URLConnection mapLocationToURLConnection(String location) throws BundleException {
        try {
            return new URL(location).openConnection();
        }
        catch (IOException e) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_URL_CREATE_EXCEPTION, location), e);
        }
    }

    public long getTotalFreeSpace() throws IOException {
        return -1L;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.stopping = false;
        this.context = context;
        BundleResourceHandler.setContext(context);
        if (this.frameworkLog == null) {
            this.frameworkLog = this.createFrameworkLog();
        }
        if (this.stateManager == null) {
            this.stateManager = this.createStateManager();
        }
        State state = this.stateManager.getSystemState();
        this.checkSystemState(state);
        BundleDescription systemBundle = state.getBundle(0L);
        if (systemBundle == null || !systemBundle.isResolved()) {
            throw new IllegalStateException();
        }
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.shutdownStateManager();
        this.context = null;
        BundleResourceHandler.setContext(null);
        this.frameworkLog.close();
        this.frameworkLog = null;
    }

    public void frameworkStopping(BundleContext context) {
        this.stopping = true;
    }

    public String getExportPackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get("Export-Package");
    }

    public String getExportServices() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get("Export-Service");
    }

    public String getProvidePackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get("Provide-Package");
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int value) {
        this.initialBundleStartLevel = value;
    }

    public BundleWatcher getBundleWatcher() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        block14: {
            this.properties = new Properties();
            String resource = System.getProperty("osgi.framework.properties", "osgi.properties");
            try {
                InputStream in = null;
                File file = new File(resource);
                if (file.exists()) {
                    in = new FileInputStream(file);
                }
                if (in == null) {
                    in = this.getClass().getResourceAsStream(resource);
                }
                if (in != null) {
                    try {
                        this.properties.load(new BufferedInputStream(in));
                        break block14;
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException ee) {}
                    }
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Skipping osgi.properties: " + resource);
                }
            }
            catch (IOException e) {
                if (!Debug.DEBUG_GENERAL) break block14;
                Debug.println("Unable to load osgi.properties: " + e.getMessage());
            }
        }
        if (this.addURLMethod != null) {
            this.properties.put("org.osgi.supports.framework.extension", "true");
        }
    }

    protected synchronized long getNextBundleId() throws IOException {
        while (this.nextId < Long.MAX_VALUE) {
            long id = this.nextId++;
            File bundleDir = new File(this.getBundleStoreRootDir(), String.valueOf(id));
            if (bundleDir.exists()) continue;
            this.persistNextBundleID(id);
            return id;
        }
        throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
    }

    protected void initDataRootDir() {
        this.dataRootDir = this.getBundleStoreRootDir();
    }

    protected void readAdaptorManifest() {
        InputStream in = null;
        Class<?> adaptorClazz = this.getClass();
        while (in == null) {
            Class<?> clazz = class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor;
            if (clazz == null) {
                clazz = new AbstractFrameworkAdaptor[0].getClass().getComponentType();
            }
            if (!clazz.isAssignableFrom(adaptorClazz)) break;
            in = adaptorClazz.getResourceAsStream("ADAPTOR.MF");
            adaptorClazz = adaptorClazz.getSuperclass();
        }
        if (in == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unable to find adaptor bundle manifest ADAPTOR.MF");
            }
            this.manifest = new Headers(new Properties());
            return;
        }
        try {
            this.manifest = Headers.parseManifest(in);
        }
        catch (BundleException e) {
            Debug.println("Unable to read adaptor bundle manifest ADAPTOR.MF");
        }
    }

    protected abstract FrameworkLog createFrameworkLog();

    public BundleData createSystemBundleData() throws BundleException {
        return new SystemBundleData(this);
    }

    public static void copyDir(File inDir, File outDir) throws IOException {
        String[] files = inDir.list();
        if (files != null && files.length > 0) {
            outDir.mkdir();
            for (int i = 0; i < files.length; ++i) {
                File inFile = new File(inDir, files[i]);
                File outFile = new File(outDir, files[i]);
                if (inFile.isDirectory()) {
                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                    continue;
                }
                FileInputStream in = new FileInputStream(inFile);
                AbstractFrameworkAdaptor.readFile(in, outFile);
            }
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unable to read file");
                Debug.printStackTrace(e);
            }
            throw e;
        }
    }

    private static Method findaddURLMethod(Class clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$java$net$URL;
            if (clazz2 == null) {
                clazz2 = class$java$net$URL = new URL[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            Method result = clazz.getDeclaredMethod("addURL", classArray);
            result.setAccessible(true);
            return result;
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return AbstractFrameworkAdaptor.findaddURLMethod(clazz.getSuperclass());
    }

    public ClassLoader getBundleClassLoaderParent() {
        return bundleClassLoaderParent;
    }

    protected void processExtension(BundleData bundleData, byte type) throws BundleException {
        if ((bundleData.getType() & 2) != 0) {
            this.validateExtension(bundleData);
            this.processFrameworkExtension(bundleData, type);
        } else if ((bundleData.getType() & 4) != 0) {
            this.validateExtension(bundleData);
            this.processBootExtension(bundleData, type);
        }
    }

    protected void validateExtension(BundleData bundleData) throws BundleException {
        Dictionary extensionManifest = bundleData.getManifest();
        if (extensionManifest.get("Import-Package") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_IMPORT_ERROR, bundleData.getLocation()));
        }
        if (extensionManifest.get("Require-Bundle") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_REQUIRE_ERROR, bundleData.getLocation()));
        }
        if (extensionManifest.get("Bundle-NativeCode") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_NATIVECODE_ERROR, bundleData.getLocation()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFrameworkExtension(BundleData bundleData, byte type) throws BundleException {
        if (this.addURLMethod == null) {
            throw new BundleException("Framework extensions are not supported.", new UnsupportedOperationException());
        }
        if ((type & 0xC) != 0) {
            return;
        }
        String[] extensions = this.getConfiguredExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!extensions[i].equals(bundleData.getSymbolicName())) continue;
            return;
        }
        File[] files = this.getExtensionFiles(bundleData);
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            Throwable exceptionLog = null;
            try {
                this.addURLMethod.invoke((Object)this.getClass().getClassLoader(), files[i].toURL());
                continue;
            }
            catch (InvocationTargetException e) {
                exceptionLog = e.getTargetException();
                continue;
            }
            catch (Throwable t) {
                exceptionLog = t;
                continue;
            }
            finally {
                if (exceptionLog != null) {
                    this.eventPublisher.publishFrameworkEvent(2, ((AbstractBundleData)bundleData).getBundle(), exceptionLog);
                }
            }
        }
    }

    protected String[] getConfiguredExtensions() {
        if (this.configuredExtensions != null) {
            return this.configuredExtensions;
        }
        String prop = System.getProperty(PROP_FRAMEWORK_EXTENSIONS);
        this.configuredExtensions = prop == null || prop.trim().length() == 0 ? new String[0] : ManifestElement.getArrayFromList(prop);
        return this.configuredExtensions;
    }

    protected void processBootExtension(BundleData bundleData, byte type) throws BundleException {
        throw new BundleException("Boot classpath extensions are not supported.", new UnsupportedOperationException());
    }

    protected File[] getExtensionFiles(BundleData bundleData) {
        File[] files = null;
        try {
            String[] paths = bundleData.getClassPath();
            if (System.getProperty("osgi.dev") != null) {
                String[] origPaths = paths;
                paths = new String[origPaths.length + 1];
                System.arraycopy(origPaths, 0, paths, 0, origPaths.length);
                paths[paths.length - 1] = "bin";
            }
            files = ((AbstractBundleData)bundleData).getClasspathFiles(paths);
        }
        catch (BundleException e) {
            this.eventPublisher.publishFrameworkEvent(2, ((AbstractBundleData)bundleData).getBundle(), e);
        }
        return files;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public File getDataRootDir() {
        if (this.dataRootDir == null) {
            this.initDataRootDir();
        }
        return this.dataRootDir;
    }

    public BundleFile createBundleFile(File basefile, BundleData bundledata) throws IOException {
        if (basefile.isDirectory()) {
            return new BundleFile.DirBundleFile(basefile);
        }
        return new BundleFile.ZipBundleFile(basefile, bundledata);
    }

    public BundleFile createBaseBundleFile(File basefile, BundleData bundledata) throws IOException {
        BundleFile base = this.createBundleFile(basefile, bundledata);
        if (System.getSecurityManager() == null || !this.supportSignedBundles) {
            return base;
        }
        SignedBundleSupport support = this.getSignedBundleSupport();
        if (support == null) {
            return base;
        }
        SignedBundle signedBundle = support.createSignedBundle();
        signedBundle.setBundleFile(base);
        return signedBundle;
    }

    public boolean matchDNChain(String pattern, String[] dnChain) {
        SignedBundleSupport support = this.getSignedBundleSupport();
        if (support != null) {
            return support.matchDNChain(pattern, dnChain);
        }
        return false;
    }

    protected SignedBundleSupport getSignedBundleSupport() {
        if (System.getSecurityManager() == null || !this.supportSignedBundles) {
            return null;
        }
        try {
            if (this.signedBundleSupport == null) {
                String clazzName = System.getProperty(PROP_SIGNINGSUPPORT, "org.eclipse.osgi.framework.pkcs7verify.SignedBundleSupportImpl");
                Class<?> clazz = Class.forName(clazzName);
                this.signedBundleSupport = (SignedBundleSupport)clazz.newInstance();
            }
            return this.signedBundleSupport;
        }
        catch (ClassNotFoundException e) {
            this.supportSignedBundles = false;
        }
        catch (IllegalAccessException e) {
            this.supportSignedBundles = false;
        }
        catch (InstantiationException e) {
            this.supportSignedBundles = false;
        }
        return null;
    }

    public BundleOperation installBundle(final String location, final URLConnection source) {
        return new BundleOperation(){
            private AbstractBundleData data;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BundleData begin() throws BundleException {
                try {
                    InputStream in = source.getInputStream();
                    URL sourceURL = source.getURL();
                    String protocol = sourceURL == null ? null : sourceURL.getProtocol();
                    try {
                        long id;
                        try {
                            id = AbstractFrameworkAdaptor.this.getNextBundleId();
                        }
                        catch (IOException e) {
                            throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, e);
                        }
                        this.data = AbstractFrameworkAdaptor.this.getElementFactory().createBundleData(AbstractFrameworkAdaptor.this, id);
                        this.data.setLastModified(System.currentTimeMillis());
                        this.data.setLocation(location);
                        this.data.setStartLevel(AbstractFrameworkAdaptor.this.getInitialBundleStartLevel());
                        if (in instanceof ReferenceInputStream) {
                            URL reference = ((ReferenceInputStream)in).getReference();
                            if (!"file".equals(reference.getProtocol())) {
                                throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_URL_CREATE_EXCEPTION, reference));
                            }
                            this.data.setReference(true);
                            this.data.setFileName(reference.getPath());
                            this.data.initializeNewBundle();
                        } else {
                            File genDir = this.data.createGenerationDir();
                            if (!genDir.exists()) {
                                throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, genDir.getPath()));
                            }
                            String fileName = AbstractFrameworkAdaptor.BUNDLEFILE_NAME;
                            File outFile = new File(genDir, fileName);
                            if ("file".equals(protocol)) {
                                File inFile = new File(source.getURL().getPath());
                                if (inFile.isDirectory()) {
                                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                                } else {
                                    AbstractFrameworkAdaptor.readFile(in, outFile);
                                }
                            } else {
                                AbstractFrameworkAdaptor.readFile(in, outFile);
                            }
                            this.data.setReference(false);
                            this.data.setFileName(fileName);
                            this.data.initializeNewBundle();
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (IOException ioe) {
                    throw new BundleException(AdaptorMsg.BUNDLE_READ_EXCEPTION, ioe);
                }
                return this.data;
            }

            public void undo() {
                block7: {
                    File delete;
                    File bundleDir;
                    block6: {
                        if (this.data != null) {
                            try {
                                this.data.close();
                            }
                            catch (IOException e) {
                                if (!Debug.DEBUG_GENERAL) break block6;
                                Debug.println("Unable to close " + this.data + ": " + e.getMessage());
                            }
                        }
                    }
                    if (this.data != null && !AbstractFrameworkAdaptor.this.rm(bundleDir = this.data.getBundleStoreDir()) && !(delete = new File(bundleDir, ".delete")).exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block7;
                            Debug.println("Unable to write " + delete.getPath() + ": " + e.getMessage());
                        }
                    }
                }
            }

            public void commit(boolean postpone) throws BundleException {
                AbstractFrameworkAdaptor.this.processExtension(this.data, (byte)2);
                try {
                    this.data.save();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, e);
                }
                AbstractFrameworkAdaptor.this.updateState(this.data, 1);
            }
        };
    }

    protected boolean rm(File file) {
        if (file.exists()) {
            String[] list;
            if (file.isDirectory() && (list = file.list()) != null) {
                int len = list.length;
                for (int i = 0; i < len; ++i) {
                    this.rm(new File(file, list[i]));
                }
            }
            if (Debug.DEBUG_GENERAL) {
                if (file.isDirectory()) {
                    Debug.println("rmdir " + file.getPath());
                } else {
                    Debug.println("rm " + file.getPath());
                }
            }
            boolean success = file.delete();
            if (Debug.DEBUG_GENERAL && !success) {
                Debug.println("  rm failed!!");
            }
            return success;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownStateManager() {
        try {
            if (this.canWrite() && (this.getBundleStoreRootDir().exists() || this.getBundleStoreRootDir().mkdirs())) {
                this.stateManager.shutdown(new File(this.getBundleStoreRootDir(), ".state"), new File(this.getBundleStoreRootDir(), ".lazy"));
            }
        }
        catch (IOException e) {
            this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), e));
        }
        finally {
            this.stateManager = null;
        }
    }

    public File getBundleStoreRootDir() {
        return this.bundleStoreRootDir;
    }

    public BundleOperation updateBundle(final BundleData bundledata, final URLConnection source) {
        return new BundleOperation(){
            private AbstractBundleData data;
            private AbstractBundleData newData;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BundleData begin() throws BundleException {
                this.data = (AbstractBundleData)bundledata;
                try {
                    block22: {
                        InputStream in = source.getInputStream();
                        URL sourceURL = source.getURL();
                        String protocol = sourceURL == null ? null : sourceURL.getProtocol();
                        try {
                            if (in instanceof ReferenceInputStream) {
                                ReferenceInputStream refIn = (ReferenceInputStream)in;
                                URL reference = refIn.getReference();
                                if (!"file".equals(reference.getProtocol())) {
                                    throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_URL_CREATE_EXCEPTION, reference));
                                }
                                String path = reference.getPath();
                                if (path.equals(this.data.getFileName())) {
                                    throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_SAME_REF_UPDATE, reference));
                                }
                                try {
                                    this.newData = this.data.nextGeneration(reference.getPath());
                                }
                                catch (IOException e) {
                                    throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, e);
                                }
                                File bundleGenerationDir = this.newData.createGenerationDir();
                                if (!bundleGenerationDir.exists()) {
                                    throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, bundleGenerationDir.getPath()));
                                }
                                this.newData.createBaseBundleFile();
                                break block22;
                            }
                            try {
                                this.newData = this.data.nextGeneration(null);
                            }
                            catch (IOException e) {
                                throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, e);
                            }
                            File bundleGenerationDir = this.newData.createGenerationDir();
                            if (!bundleGenerationDir.exists()) {
                                throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, bundleGenerationDir.getPath()));
                            }
                            File outFile = this.newData.getBaseFile();
                            if ("file".equals(protocol)) {
                                File inFile = new File(source.getURL().getPath());
                                if (inFile.isDirectory()) {
                                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                                } else {
                                    AbstractFrameworkAdaptor.readFile(in, outFile);
                                }
                            } else {
                                AbstractFrameworkAdaptor.readFile(in, outFile);
                            }
                            this.newData.createBaseBundleFile();
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException ee) {}
                        }
                    }
                    this.newData.loadFromManifest();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.BUNDLE_READ_EXCEPTION, e);
                }
                return this.newData;
            }

            public void commit(boolean postpone) throws BundleException {
                File delete;
                AbstractFrameworkAdaptor.this.processExtension(this.data, (byte)4);
                AbstractFrameworkAdaptor.this.processExtension(this.newData, (byte)8);
                try {
                    this.newData.setLastModified(System.currentTimeMillis());
                    this.newData.save();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, e);
                }
                AbstractFrameworkAdaptor.this.updateState(this.newData, 8);
                File originalGenerationDir = this.data.createGenerationDir();
                if (!(!postpone && AbstractFrameworkAdaptor.this.rm(originalGenerationDir) || (delete = new File(originalGenerationDir, ".delete")).exists())) {
                    try {
                        FileOutputStream out = new FileOutputStream(delete);
                        out.close();
                    }
                    catch (IOException e) {
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("Unable to write " + delete.getPath() + ": " + e.getMessage());
                        }
                        AbstractFrameworkAdaptor.this.eventPublisher.publishFrameworkEvent(2, this.data.getBundle(), e);
                    }
                }
            }

            public void undo() throws BundleException {
                block3: {
                    File delete;
                    File nextGenerationDir;
                    if (this.newData != null && !AbstractFrameworkAdaptor.this.rm(nextGenerationDir = this.newData.createGenerationDir()) && !(delete = new File(nextGenerationDir, ".delete")).exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block3;
                            Debug.println("Unable to write " + delete.getPath() + ": " + e.getMessage());
                        }
                    }
                }
            }
        };
    }

    protected void checkSystemState(State state) {
        BundleDescription[] bundles = state.getBundles();
        if (bundles == null) {
            return;
        }
        boolean removedBundle = false;
        for (int i = 0; i < bundles.length; ++i) {
            if (this.context.getBundle(bundles[i].getBundleId()) != null) continue;
            state.removeBundle(bundles[i]);
            removedBundle = true;
        }
        if (removedBundle) {
            state.resolve(false);
        }
    }

    protected StateManager createStateManager() {
        this.stateManager = new StateManager(new File(this.getBundleStoreRootDir(), ".state"), new File(this.getBundleStoreRootDir(), ".lazy"), this.context);
        State systemState = null;
        if (!this.invalidState && (systemState = this.stateManager.readSystemState()) != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        Bundle[] installedBundles = this.context.getBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        for (int i = 0; i < installedBundles.length; ++i) {
            Bundle toAdd = installedBundles[i];
            try {
                Dictionary manifest = toAdd.getHeaders("");
                BundleDescription newDescription = factory.createBundleDescription(systemState, manifest, toAdd.getLocation(), toAdd.getBundleId());
                systemState.addBundle(newDescription);
                continue;
            }
            catch (BundleException be) {
                // empty catch block
            }
        }
        systemState.resolve();
        this.invalidState = false;
        return this.stateManager;
    }

    public BundleOperation uninstallBundle(final BundleData bundledata) {
        return new BundleOperation(){
            private AbstractBundleData data;

            public BundleData begin() throws BundleException {
                this.data = (AbstractBundleData)bundledata;
                return bundledata;
            }

            public void commit(boolean postpone) throws BundleException {
                block3: {
                    File delete;
                    File bundleDir = this.data.getBundleStoreDir();
                    if (!(!postpone && AbstractFrameworkAdaptor.this.rm(bundleDir) || (delete = new File(bundleDir, ".delete")).exists())) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block3;
                            Debug.println("Unable to write " + delete.getPath() + ": " + e.getMessage());
                        }
                    }
                }
                AbstractFrameworkAdaptor.this.processExtension(this.data, (byte)4);
                this.data.setLastModified(System.currentTimeMillis());
                AbstractFrameworkAdaptor.this.updateState(this.data, 16);
            }

            public void undo() throws BundleException {
            }
        };
    }

    protected void initBundleStoreRootDir() {
        if (this.bundleStore == null) {
            this.bundleStore = System.getProperty(BUNDLE_STORE);
            if (this.bundleStore == null) {
                this.bundleStore = this.properties.getProperty(BUNDLE_STORE, "bundles");
            }
        }
        this.bundleStoreRootDir = new File(this.bundleStore);
        this.properties.put(BUNDLE_STORE, this.bundleStoreRootDir.getAbsolutePath());
    }

    protected ServiceRegistration register(String name, Object service, Bundle bundle) {
        Hashtable properties = new Hashtable(7);
        Dictionary headers = bundle.getHeaders();
        properties.put("service.vendor", headers.get("Bundle-Vendor"));
        properties.put("service.ranking", new Integer(Integer.MAX_VALUE));
        properties.put("service.pid", bundle.getBundleId() + "." + service.getClass().getName());
        return this.context.registerService(name, service, properties);
    }

    public void initializeStorage() throws IOException {
        File bundleStore;
        if (this.reset && (bundleStore = this.getBundleStoreRootDir()).exists() && (!this.canWrite() || !this.rm(bundleStore))) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Could not remove directory: " + bundleStore.getPath());
            }
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_REMOVE_EXCEPTION, bundleStore));
        }
        this.initializeMetadata();
    }

    protected abstract void initializeMetadata() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionStorage getPermissionStorage() throws IOException {
        if (this.permissionStore == null) {
            AbstractFrameworkAdaptor abstractFrameworkAdaptor = this;
            synchronized (abstractFrameworkAdaptor) {
                if (this.permissionStore == null) {
                    this.permissionStore = new DefaultPermissionStorage(this);
                }
            }
        }
        return this.permissionStore;
    }

    public void compactStorage() {
        if (this.canWrite()) {
            this.compact(this.getBundleStoreRootDir());
        }
    }

    private void compact(File directory) {
        String[] list;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("compact(" + directory.getPath() + ")");
        }
        if ((list = directory.list()) == null) {
            return;
        }
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            File target;
            if (DATA_DIR_NAME.equals(list[i]) || !(target = new File(directory, list[i])).isDirectory()) continue;
            File delete = new File(target, ".delete");
            if (delete.exists()) {
                if (this.rm(target) || delete.exists()) continue;
                try {
                    FileOutputStream out = new FileOutputStream(delete);
                    out.close();
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_GENERAL) continue;
                    Debug.println("Unable to write " + delete.getPath() + ": " + e.getMessage());
                }
                continue;
            }
            this.compact(target);
        }
    }

    protected File getMetaDataFile() {
        return new File(this.getBundleStoreRootDir(), ".framework");
    }

    protected void updateState(BundleData bundleData, int type) throws BundleException {
        if (this.stateManager == null) {
            this.invalidState = true;
            return;
        }
        State systemState = this.stateManager.getSystemState();
        switch (type) {
            case 8: {
                systemState.removeBundle(bundleData.getBundleID());
            }
            case 1: {
                BundleDescription newDescription = this.stateManager.getFactory().createBundleDescription(systemState, bundleData.getManifest(), bundleData.getLocation(), bundleData.getBundleID());
                systemState.addBundle(newDescription);
                break;
            }
            case 16: {
                systemState.removeBundle(bundleData.getBundleID());
            }
        }
    }

    public boolean canWrite() {
        return true;
    }

    static {
        ClassLoader appCL;
        String type = System.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT);
        if (PARENT_CLASSLOADER_FWK.equalsIgnoreCase(type)) {
            Class<?> clazz = class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor;
            if (clazz == null) {
                clazz = class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor = new FrameworkAdaptor[0].getClass().getComponentType();
            }
            bundleClassLoaderParent = clazz.getClassLoader();
        } else if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(type)) {
            bundleClassLoaderParent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(type) && (appCL = ClassLoader.getSystemClassLoader()) != null) {
            bundleClassLoaderParent = appCL.getParent();
        }
        if (bundleClassLoaderParent == null) {
            bundleClassLoaderParent = new ParentClassLoader();
        }
    }

    protected static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            super(null);
        }
    }
}

