/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;

public class DefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    private static final String ELEMENT_INITIALIZER = "initializer";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final IPath NL_DIR = new Path("$nl$");
    public static final String PRODUCT_KEY = "preferenceCustomization";
    private static final String LEGACY_PRODUCT_CUSTOMIZATION_FILENAME = "plugin_customization.ini";
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private static Properties productCustomization;
    private static Properties productTranslation;
    private static Properties commandLineCustomization;
    private EclipsePreferences loadLevel;
    private String qualifier;
    private int segmentCount;
    private Plugin plugin;

    public DefaultPreferences() {
        this(null, null);
    }

    private DefaultPreferences(EclipsePreferences parent, String name, Plugin context) {
        this(parent, name);
        this.plugin = context;
    }

    private DefaultPreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        if (parent instanceof DefaultPreferences) {
            this.plugin = ((DefaultPreferences)parent).plugin;
        }
        String path = this.absolutePath();
        this.segmentCount = DefaultPreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = DefaultPreferences.getSegment(path, 1);
    }

    private void applyBundleDefaults() {
        Bundle bundle = Platform.getBundle(this.name());
        if (bundle == null) {
            return;
        }
        URL url = Platform.find(bundle, new Path("preferences.ini"));
        if (url == null) {
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("Preference default override file not found for bundle: " + bundle.getSymbolicName());
            }
            return;
        }
        URL transURL = Platform.find(bundle, NL_DIR.append("preferences").addFileExtension(PROPERTIES_FILE_EXTENSION));
        if (transURL == null && InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
            Policy.debug("Preference translation file not found for bundle: " + bundle.getSymbolicName());
        }
        this.applyDefaults(this.name(), this.loadProperties(url), this.loadProperties(transURL));
    }

    private void applyCommandLineDefaults() {
        if (commandLineCustomization == null) {
            String filename = InternalPlatform.pluginCustomizationFile;
            if (filename == null) {
                if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                    Policy.debug("Command-line preferences customization file not specified.");
                }
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("Using command-line preference customization file: " + filename);
            }
            commandLineCustomization = this.loadProperties(filename);
        }
        this.applyDefaults(null, commandLineCustomization, null);
    }

    private void applyDefaults(String id, Properties defaultValues, Properties translations) {
        Enumeration<Object> e = defaultValues.keys();
        while (e.hasMoreElements()) {
            String fullKey = (String)e.nextElement();
            String value = defaultValues.getProperty(fullKey);
            if (value == null) continue;
            IPath childPath = new Path(fullKey);
            String key = childPath.lastSegment();
            childPath = childPath.removeLastSegments(1);
            String localQualifier = id;
            if (id == null) {
                localQualifier = childPath.segment(0);
                childPath = childPath.removeFirstSegments(1);
            }
            if (!this.name().equals(localQualifier)) continue;
            value = this.translatePreference(value, translations);
            if (InternalPlatform.DEBUG_PREFERENCE_SET) {
                Policy.debug("Setting default preference: " + new Path(this.absolutePath()).append(childPath).append(key) + '=' + value);
            }
            ((EclipsePreferences)this.internalNode(((Object)childPath).toString(), false, null)).internalPut(key, value);
        }
    }

    private void runInitializer(IConfigurationElement element) {
        AbstractPreferenceInitializer initializer = null;
        try {
            initializer = (AbstractPreferenceInitializer)element.createExecutableExtension(ATTRIBUTE_CLASS);
            initializer.initializeDefaultPreferences();
        }
        catch (ClassCastException e) {
            Status status = new Status(4, "org.eclipse.core.runtime", 4, Messages.preferences_invalidExtensionSuperclass, e);
            DefaultPreferences.log(status);
        }
        catch (CoreException e) {
            DefaultPreferences.log(e.getStatus());
        }
    }

    public IEclipsePreferences node(String childName, Plugin context) {
        return this.internalNode(childName, true, context);
    }

    private void applyRuntimeDefaults() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.runtime", "preferences");
        if (point == null) {
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("No extensions for org.eclipse.core.runtime.preferences extension point. Skipping runtime default preference customization.");
            }
            return;
        }
        IExtension[] extensions = point.getExtensions();
        boolean foundInitializer = false;
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (ELEMENT_INITIALIZER.equals(elements[j].getName()) && this.name().equals(elements[j].getNamespace())) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("Running default preference customization as defined by: " + elements[j].getDeclaringExtension().getDeclaringPluginDescriptor());
                    }
                    this.runInitializer(elements[j]);
                    foundInitializer = true;
                }
                ++j;
            }
            ++i;
        }
        if (foundInitializer) {
            return;
        }
        if (this.plugin == null && InternalPlatform.getDefault().getBundle("org.eclipse.core.runtime.compatibility") != null) {
            this.plugin = Platform.getPlugin(this.name());
        }
        if (this.plugin == null) {
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("No plug-in object available to set plug-in default preference overrides for:" + this.name());
            }
            return;
        }
        if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
            Policy.debug("Applying plug-in default preference overrides for plug-in: " + this.plugin.getDescriptor().getUniqueIdentifier());
        }
        this.plugin.internalInitializeDefaultPluginPreferences();
    }

    private void applyProductDefaults() {
        if (productCustomization == null) {
            URL transURL;
            URL url;
            String value;
            Bundle bundle;
            String id;
            block15: {
                IProduct product = Platform.getProduct();
                if (product == null) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("Product not available to set product default preference overrides.");
                    }
                    return;
                }
                id = product.getId();
                if (id == null) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("Product ID not available to apply product-level preference defaults.");
                    }
                    return;
                }
                bundle = product.getDefiningBundle();
                if (bundle == null) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("Bundle not available to apply product-level preference defaults for product id: " + id);
                    }
                    return;
                }
                value = product.getProperty(PRODUCT_KEY);
                url = null;
                transURL = null;
                if (value == null) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("Product : " + id + " does not define preference customization file. Using legacy file: plugin_customization.ini");
                    }
                    value = LEGACY_PRODUCT_CUSTOMIZATION_FILENAME;
                    url = Platform.find(bundle, new Path(LEGACY_PRODUCT_CUSTOMIZATION_FILENAME));
                    transURL = Platform.find(bundle, NL_DIR.append(value).removeFileExtension().addFileExtension(PROPERTIES_FILE_EXTENSION));
                } else {
                    try {
                        url = new URL(value);
                    }
                    catch (MalformedURLException malformedURLException) {
                        url = Platform.find(bundle, new Path(value));
                        if (url == null) break block15;
                        transURL = Platform.find(bundle, NL_DIR.append(value).removeFileExtension().addFileExtension(PROPERTIES_FILE_EXTENSION));
                    }
                }
            }
            if (url == null) {
                if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                    Policy.debug("Product preference customization file: " + value + " not found for bundle: " + id);
                }
                return;
            }
            if (transURL == null && InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("No preference translations found for product/file: " + bundle.getSymbolicName() + '/' + value);
            }
            productCustomization = this.loadProperties(url);
            productTranslation = this.loadProperties(transURL);
        }
        this.applyDefaults(null, productCustomization, productTranslation);
    }

    public void flush() {
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new DefaultPreferences(nodeParent, nodeName, context);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void load() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.applyRuntimeDefaults();
        this.applyBundleDefaults();
        this.applyProductDefaults();
        this.applyCommandLineDefaults();
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 89->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 128->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() {
    }

    private String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value.substring(1) : value.substring(1, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key, dflt);
        }
        return value;
    }
}

