/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.CommandContainer;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SetQuery
extends QueryCommand
implements CommandContainer {
    public static final int UNION = 0;
    public static final int INTERSECT = 1;
    public static final int EXCEPT = 2;
    private int operation;
    private List queries = new ArrayList();
    private List allFlags = new ArrayList();
    private List projectedTypes = null;

    public SetQuery() {
    }

    public SetQuery(int operation) {
        this.operation = operation;
    }

    public int getType() {
        return 1;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void addQuery(QueryCommand query) {
        this.addQuery(query, true);
    }

    public void addQuery(QueryCommand query, boolean useAll) {
        if (this.queries.isEmpty()) {
            useAll = true;
        }
        this.queries.add(query);
        this.allFlags.add(useAll);
    }

    public void addQueries(List queries, List useAll) {
        this.queries.addAll(queries);
        this.allFlags.addAll(useAll);
    }

    public void removeAllQueries() {
        this.queries.clear();
        this.allFlags.clear();
    }

    public List getQueries() {
        return this.queries;
    }

    public List getUseAllFlags() {
        return this.allFlags;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        if (this.queries.size() > 0) {
            List projectedSymbols = ((QueryCommand)this.queries.get(0)).getProjectedSymbols();
            if (this.projectedTypes != null) {
                return SetQuery.getTypedProjectedSymbols(projectedSymbols, this.projectedTypes);
            }
            return projectedSymbols;
        }
        return Collections.EMPTY_LIST;
    }

    public static List getTypedProjectedSymbols(List acutal, List projectedTypes) {
        ArrayList<SingleElementSymbol> newProject = new ArrayList<SingleElementSymbol>();
        for (int i = 0; i < acutal.size(); ++i) {
            SingleElementSymbol originalSymbol;
            SingleElementSymbol symbol = originalSymbol = (SingleElementSymbol)acutal.get(i);
            Class type = (Class)projectedTypes.get(i);
            if (symbol.getType() != type) {
                if (symbol instanceof AliasSymbol) {
                    symbol = ((AliasSymbol)symbol).getSymbol();
                }
                Expression expr = null;
                expr = symbol instanceof ExpressionSymbol ? ((ExpressionSymbol)symbol).getExpression() : symbol;
                try {
                    symbol = new ExpressionSymbol(originalSymbol.getShortName(), ResolverUtil.convertExpression((Expression)expr, (String)DataTypeManager.getDataTypeName(type)));
                }
                catch (QueryResolverException err) {
                    throw new MetaMatrixRuntimeException(err);
                }
                if (!(originalSymbol instanceof ExpressionSymbol)) {
                    symbol = new AliasSymbol(originalSymbol.getShortName(), symbol);
                }
            }
            newProject.add(symbol);
        }
        return newProject;
    }

    public static String getOperationString(int setOperation) {
        if (setOperation == 0) {
            return "UNION";
        }
        if (setOperation == 1) {
            return "INTERSECT";
        }
        if (setOperation == 2) {
            return "EXCEPT";
        }
        return "null";
    }

    public Object clone() {
        SetQuery copy = new SetQuery(this.operation);
        this.copyMetadataState(copy);
        ArrayList<Object> copyQueries = new ArrayList<Object>(this.queries.size());
        Iterator iter = this.queries.iterator();
        while (iter.hasNext()) {
            QueryCommand subQuery = (QueryCommand)iter.next();
            copyQueries.add(subQuery.clone());
        }
        ArrayList copyAllFlags = new ArrayList(this.allFlags);
        copy.addQueries(copyQueries, copyAllFlags);
        if (this.getOrderBy() != null) {
            copy.setOrderBy((OrderBy)this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            copy.setLimit((Limit)this.getLimit().clone());
        }
        if (this.getOption() != null) {
            copy.setOption((Option)this.getOption().clone());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetQuery other = (SetQuery)obj;
        return this.getOperation() == other.getOperation() && EquivalenceUtil.areEqual(this.getQueries(), other.getQueries()) && EquivalenceUtil.areEqual(this.getUseAllFlags(), other.getUseAllFlags()) && EquivalenceUtil.areEqual(this.getOrderBy(), other.getOrderBy()) && EquivalenceUtil.areEqual(this.getLimit(), other.getLimit()) && EquivalenceUtil.areEqual(this.getOption(), other.getOption());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.operation);
        if (this.queries.size() > 0) {
            myHash = HashCodeUtil.hashCode(myHash, this.queries.get(0));
        }
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean areResultsCachable() {
        for (int i = 0; i < this.queries.size(); ++i) {
            Query query = (Query)this.queries.get(i);
            if (query.getInto() == null) continue;
            return false;
        }
        return true;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return this.getSubCommandsUpdatingModelCount(metadata);
    }

    public List getContainedCommands() {
        return this.queries;
    }

    public void setProjectedTypes(List projectedTypes) {
        this.projectedTypes = projectedTypes;
    }

    public List getProjectedTypes() {
        return this.projectedTypes;
    }
}

