/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.util.Stopwatch;
import java.util.ArrayList;
import java.util.List;

public class DebuggingStopwatch {
    private static final String NEW_LINE = "\n";
    private static final String SPACER = "   -- > ";
    private static final String DELTA_TIME = " Delta Time (ms) = ";
    private static final String TOTAL_TIME = " Total Time (ms) = ";
    private static final String STOPWATCH_STATS = " ===>> Stopwatch Statistics for: ";
    private static final String END = " =========== END STATS =============";
    private String title;
    private long[] increments;
    private List messages;
    private int nValues = 0;
    private Stopwatch incStopwatch;
    private Stopwatch totalStopwatch;

    public DebuggingStopwatch(String title, int maxStatistics, boolean printStart) {
        this.title = title;
        this.increments = new long[maxStatistics];
        this.messages = new ArrayList(maxStatistics);
        this.incStopwatch = new Stopwatch();
        this.totalStopwatch = new Stopwatch();
        if (printStart) {
            System.out.println(" *** Stopwatch Statistics intiated for: " + title);
        }
    }

    public void addStat(String message) {
        this.messages.add(message);
        this.incStopwatch.stop();
        this.increments[this.nValues] = this.incStopwatch.getTotalDuration();
        this.incStopwatch.start(true);
        ++this.nValues;
    }

    public void stopStats() {
        this.incStopwatch.stop();
        this.incStopwatch.reset();
    }

    public void startStats() {
        this.incStopwatch.start(true);
    }

    public void start() {
        this.totalStopwatch.start();
    }

    public void stop() {
        this.totalStopwatch.stop();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(STOPWATCH_STATS + this.title + NEW_LINE);
        for (int i = 0; i < this.nValues; ++i) {
            sb.append(SPACER + this.messages.get(i) + DELTA_TIME + this.increments[i] + NEW_LINE);
        }
        sb.append(TOTAL_TIME + this.totalStopwatch.getTotalDuration() + NEW_LINE);
        sb.append(END);
        return sb.toString();
    }

    public void print() {
        System.out.println(this);
    }
}

