/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.util.ArgCheck;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ChecksumInputStream
extends InputStream {
    private final Checksum checksum;
    private final InputStream delegate;

    public ChecksumInputStream(InputStream delegate) {
        ArgCheck.isNotNull(delegate);
        this.delegate = delegate;
        this.checksum = new CRC32();
    }

    public int read() throws IOException {
        int result = this.delegate.read();
        if (result != -1) {
            this.checksum.update(result);
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numBytesRead = this.delegate.read(b, off, len);
        if (numBytesRead != -1) {
            this.checksum.update(b, off, numBytesRead);
        }
        return numBytesRead;
    }

    public long getChecksumValue() {
        return this.checksum.getValue();
    }
}

