/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.cipher;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Encryptor;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;

public class SerializableEncryptor
implements Encryptor,
Serializable {
    public static final String DEFAULT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    public static final char[] ENCRYPTED_PREFIX;
    private transient Key encryptKey;
    protected transient Cipher encryptCipher;
    private byte[] encodedKey;
    private String keyAlgorithm;
    protected String cipherAlgorithm;

    public SerializableEncryptor() {
    }

    public SerializableEncryptor(Key encryptKey, String algorithm) throws CryptoException {
        this.encryptKey = encryptKey;
        this.encodedKey = encryptKey.getEncoded();
        this.keyAlgorithm = encryptKey.getAlgorithm();
        this.cipherAlgorithm = algorithm;
        if (this.encodedKey == null) {
            throw new CryptoException("Encodedkey was null");
        }
    }

    public SerializableEncryptor(Key encryptKey) throws CryptoException {
        this(encryptKey, DEFAULT_ALGORITHM);
    }

    public synchronized byte[] encrypt(byte[] cleartext) throws CryptoException {
        if (this.encryptCipher == null) {
            this.initCipher();
        }
        try {
            return this.encryptCipher.doFinal(cleartext);
        }
        catch (Exception e) {
            try {
                this.initCipher();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            throw new CryptoException("ERR.003.030.0081", CommonPlugin.Util.getString("ERR.003.030.0081", e.getMessage()));
        }
    }

    public char[] encrypt(char[] cleartext) throws CryptoException {
        if (cleartext == null) {
            throw new CryptoException("ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0072"));
        }
        String clearString = new String(cleartext);
        if (clearString.trim().length() == 0 && clearString.length() == 0) {
            throw new CryptoException("ERR.003.030.0073", CommonPlugin.Util.getString("ERR.003.030.0073"));
        }
        byte[] clearBytes = clearString.getBytes();
        byte[] cipherBytes = this.encrypt(clearBytes);
        char[] encoded = CryptoFactory.encodeBytes(cipherBytes);
        char[] result = new char[encoded.length + ENCRYPTED_PREFIX.length];
        System.arraycopy(ENCRYPTED_PREFIX, 0, result, 0, ENCRYPTED_PREFIX.length);
        System.arraycopy(encoded, 0, result, ENCRYPTED_PREFIX.length, encoded.length);
        return result;
    }

    protected synchronized void initCipher() throws CryptoException {
        try {
            KeyFactory keyFactory = null;
            if (this.encryptKey == null) {
                keyFactory = KeyFactory.getInstance(this.keyAlgorithm);
                X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(this.encodedKey);
                this.encryptKey = keyFactory.generatePublic(publicKeySpec);
            }
            this.encryptCipher = Cipher.getInstance(this.cipherAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0076", CommonPlugin.Util.getString("ERR.003.030.0076", this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0077", this.cipherAlgorithm, e.getMessage()));
        }
        catch (Throwable e) {
            throw new CryptoException(e, "ERR.003.030.0082", CommonPlugin.Util.getString("ERR.003.030.0082", e.getClass().getName(), this.cipherAlgorithm));
        }
        try {
            this.encryptCipher.init(1, this.encryptKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0078", CommonPlugin.Util.getString("ERR.003.030.0078", e.getMessage()));
        }
        catch (Throwable e) {
            throw new CryptoException(e, "ERR.003.030.0083", CommonPlugin.Util.getString("ERR.003.030.0083", new Object[]{e.getClass().getName(), this.encryptCipher, new Integer(1), this.encryptKey}));
        }
    }

    public synchronized Serializable sealObject(Serializable object) throws CryptoException {
        if (this.encryptCipher == null) {
            this.initCipher();
        }
        try {
            return new SealedObject(object, this.encryptCipher);
        }
        catch (Exception e) {
            try {
                this.initCipher();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            throw new CryptoException("ERR.003.030.0081", CommonPlugin.Util.getString("ERR.003.030.0081", e.getMessage()));
        }
    }

    static {
        CryptoUtil.initJCEProvider();
        ENCRYPTED_PREFIX = "{mmencrypt}".toCharArray();
    }
}

