/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.common.types.Sequencable;
import com.metamatrix.common.types.Streamable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public final class ClobType
implements Streamable,
Clob,
Sequencable {
    transient Clob srcClob;
    String streamId;
    String persistentId;
    long length = -1L;

    ClobType() {
    }

    public ClobType(Clob clob) {
        if (clob == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ClobValue.isNUll"));
        }
        this.srcClob = clob;
        try {
            this.length = clob.length();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getReferenceStreamId() {
        return this.streamId;
    }

    public void setReferenceStreamId(String id) {
        this.streamId = id;
    }

    public String getPersistenceStreamId() {
        return this.persistentId;
    }

    public void setPersistenceStreamId(String id) {
        this.persistentId = id;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.checkReference();
        return this.srcClob.getAsciiStream();
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkReference();
        return this.srcClob.getCharacterStream();
    }

    public String getSubString(long pos, int length) throws SQLException {
        this.checkReference();
        return this.srcClob.getSubString(pos, length);
    }

    public long length() throws SQLException {
        if (this.length != -1L) {
            return this.length;
        }
        this.checkReference();
        return this.srcClob.length();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        this.checkReference();
        return this.srcClob.position(searchstr, start);
    }

    public long position(String searchstr, long start) throws SQLException {
        this.checkReference();
        return this.srcClob.position(searchstr, start);
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkReference();
        return this.srcClob.setAsciiStream(pos);
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkReference();
        return this.srcClob.setCharacterStream(pos);
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkReference();
        return this.srcClob.setString(pos, str, offset, len);
    }

    public int setString(long pos, String str) throws SQLException {
        this.checkReference();
        return this.srcClob.setString(pos, str);
    }

    public void truncate(long len) throws SQLException {
        this.checkReference();
        this.srcClob.truncate(len);
    }

    public boolean equals(Object o) {
        this.checkReference();
        return this.srcClob.equals(o);
    }

    public String toString() {
        this.checkReference();
        return this.srcClob.toString();
    }

    private void checkReference() {
        if (this.srcClob == null) {
            throw new InvalidReferenceException(CommonPlugin.Util.getString("ClobValue.InvalidReference"));
        }
    }

    public static String getString(Clob clob) throws SQLException, IOException {
        Reader reader = clob.getCharacterStream();
        StringWriter writer = new StringWriter();
        int c = reader.read();
        while (c != -1) {
            writer.write((char)c);
            c = reader.read();
        }
        reader.close();
        String data = writer.toString();
        writer.close();
        return data;
    }

    public CharSequence getCharSequence() {
        this.checkReference();
        return new CharSequence(){

            public int length() {
                long result;
                try {
                    result = ClobType.this.length();
                }
                catch (SQLException err) {
                    throw new MetaMatrixRuntimeException(err);
                }
                if ((long)((int)result) != result) {
                    throw new MetaMatrixRuntimeException("Clob value is not representable by CharSequence");
                }
                return (int)result;
            }

            public char charAt(int index) {
                try {
                    return ClobType.this.getSubString(index + 1, 1).charAt(0);
                }
                catch (SQLException err) {
                    throw new MetaMatrixRuntimeException(err);
                }
            }

            public CharSequence subSequence(int start, int end) {
                try {
                    return ClobType.this.getSubString(start + 1, end - start);
                }
                catch (SQLException err) {
                    throw new MetaMatrixRuntimeException(err);
                }
            }
        };
    }
}

