/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.lob.ByteLobChunk;
import com.metamatrix.common.lob.ExceptionLobChunk;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LobChunkInputStream
extends InputStream {
    LobChunkProducer reader;
    byte[] byteData = null;
    int currentCounter = 0;
    boolean lastChunk = false;
    int availableCounter = 0;
    boolean closed = false;
    byte[] contents = null;

    public LobChunkInputStream(LobChunkProducer reader) {
        this.reader = reader;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CommonPlugin.Util.getString("stream_closed"));
        }
        if (this.lastChunk && this.availableCounter == 0) {
            return -1;
        }
        if (!this.lastChunk && this.availableCounter == 0) {
            this.fetchNextChunk();
        }
        if (this.availableCounter > 0) {
            int copy = len;
            if (len > this.availableCounter) {
                copy = this.availableCounter;
            }
            this.availableCounter -= copy;
            System.arraycopy(this.byteData, this.currentCounter, b, off, copy);
            this.currentCounter += copy;
            return copy;
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CommonPlugin.Util.getString("stream_closed"));
        }
        if (this.lastChunk && this.availableCounter == 0) {
            return -1;
        }
        if (!this.lastChunk && this.availableCounter == 0) {
            this.fetchNextChunk();
        }
        int ret = -1;
        if (this.availableCounter > 0) {
            if (this.byteData != null) {
                ret = this.byteData[this.currentCounter++] & 0xFF;
            }
            --this.availableCounter;
        }
        return ret;
    }

    void fetchNextChunk() throws IOException {
        LobChunk value = null;
        while (value == null) {
            value = this.reader.getNextChunk();
            if (value != null && value instanceof ByteLobChunk) {
                this.lastChunk = value.isLast();
                this.byteData = ((ByteLobChunk)value).getBytes();
                this.currentCounter = 0;
                this.availableCounter = this.byteData.length;
                continue;
            }
            if (value != null && value instanceof ExceptionLobChunk) {
                Throwable e = ((ExceptionLobChunk)value).getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e.getMessage());
            }
            throw new IOException(CommonPlugin.Util.getString("lob.invaliddata"));
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }

    public byte[] getByteContents() throws IOException {
        if (this.contents == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(102400);
            byte[] buf = new byte[102400];
            int read = this.read(buf);
            while (read != -1) {
                bos.write(buf, 0, read);
                read = this.read(buf);
            }
            this.close();
            this.contents = bos.toByteArray();
            bos.close();
        }
        return this.contents;
    }
}

