/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.objects.Session;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.core.util.DateUtil;
import java.util.Date;

public class MMSession
extends MMAdminObject
implements Session {
    private String userName = "";
    private String applicationName = "";
    private long sessionID = Long.parseLong(this.getIdentifier());
    private String vdbName = "";
    private String vdbVersion = "";
    private String productName = "";
    private String ipAddress = "";
    private String hostName = "";
    private long lastPingTime;
    private int sessionState;

    public MMSession(String[] identifierParts) {
        super(identifierParts);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(AdminPlugin.Util.getString("MMSession.MMSession")).append(this.getIdentifier());
        result.append(AdminPlugin.Util.getString("MMSession.User_Name")).append(this.userName);
        result.append(AdminPlugin.Util.getString("MMSession.Application")).append(this.applicationName);
        result.append(AdminPlugin.Util.getString("MMSession.ID")).append(this.sessionID);
        result.append(AdminPlugin.Util.getString("MMSession.VDB_Name")).append(this.vdbName);
        result.append(AdminPlugin.Util.getString("MMSession.VDB_Version")).append(this.vdbVersion);
        result.append(AdminPlugin.Util.getString("MMSession.Product")).append(this.productName);
        result.append(AdminPlugin.Util.getString("MMSession.Last_Ping_Time")).append(this.getLastPingTimeString());
        result.append(AdminPlugin.Util.getString("MMSession.State")).append(this.getStateAsString());
        result.append(AdminPlugin.Util.getString("MMSession.IPAddress")).append(this.ipAddress);
        result.append(AdminPlugin.Util.getString("MMSession.HostName")).append(this.hostName);
        return result.toString();
    }

    public Date getLastPingTime() {
        return new Date(this.lastPingTime);
    }

    public String getLastPingTimeString() {
        return DateUtil.getDateAsString(this.getLastPingTime());
    }

    public void setLastPingTime(long lastPingTime) {
        this.lastPingTime = lastPingTime;
    }

    public String getStateAsString() {
        String result = "";
        switch (this.sessionState) {
            case 4: {
                result = "Expired";
                break;
            }
            case 1: {
                result = "Active";
                break;
            }
            case 3: {
                result = "Closed";
                break;
            }
            case 5: {
                result = "Terminated";
                break;
            }
            case 2: {
                result = "Passivated";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }

    public void setSessionState(int state) {
        this.sessionState = state;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String name) {
        this.productName = name;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public int getState() {
        return this.sessionState;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public void setVDBName(String vdbName) {
        this.vdbName = vdbName;
    }

    public String getVDBVersion() {
        return this.vdbVersion;
    }

    public void setVDBVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion;
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public void setHostName(String clientMachineName) {
        this.hostName = clientMachineName;
    }

    public String getHostName() {
        return this.hostName;
    }
}

