/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.Cache;
import com.metamatrix.admin.api.objects.ConnectionPool;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.ConnectorType;
import com.metamatrix.admin.api.objects.DQP;
import com.metamatrix.admin.api.objects.Entitlement;
import com.metamatrix.admin.api.objects.ExtensionModule;
import com.metamatrix.admin.api.objects.Group;
import com.metamatrix.admin.api.objects.Host;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.Model;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.objects.PropertyDefinition;
import com.metamatrix.admin.api.objects.QueueWorkerPool;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.api.objects.Resource;
import com.metamatrix.admin.api.objects.Role;
import com.metamatrix.admin.api.objects.Session;
import com.metamatrix.admin.api.objects.SourceRequest;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.User;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public abstract class MMAdminObject
implements AdminObject,
Serializable {
    public static final long serialVersionUID = -8280437282118346149L;
    public static final String OBJECTS_PACKAGE = "com.metamatrix.admin.api.objects.";
    public static final int OBJECT_TYPE_CACHE = 0;
    public static final int OBJECT_TYPE_CONNECTION_POOL = 1;
    public static final int OBJECT_TYPE_CONNECTOR_BINDING = 2;
    public static final int OBJECT_TYPE_CONNECTOR_TYPE = 3;
    public static final int OBJECT_TYPE_DQP = 4;
    public static final int OBJECT_TYPE_ENTITLEMENT = 5;
    public static final int OBJECT_TYPE_EXTENSION_MODULE = 6;
    public static final int OBJECT_TYPE_GROUP = 7;
    public static final int OBJECT_TYPE_HOST = 8;
    public static final int OBJECT_TYPE_LOG_CONFIGURATION = 9;
    public static final int OBJECT_TYPE_MODEL = 10;
    public static final int OBJECT_TYPE_PROCESS_OBJECT = 11;
    public static final int OBJECT_TYPE_PROPERTY_DEFINITION = 12;
    public static final int OBJECT_TYPE_QUEUE_WORKER_POOL = 13;
    public static final int OBJECT_TYPE_REQUEST = 14;
    public static final int OBJECT_TYPE_RESOURCE = 15;
    public static final int OBJECT_TYPE_ROLE = 16;
    public static final int OBJECT_TYPE_SESSION = 17;
    public static final int OBJECT_TYPE_SOURCE_REQUEST = 18;
    public static final int OBJECT_TYPE_SYSTEM_OBJECT = 19;
    public static final int OBJECT_TYPE_USER = 20;
    public static final int OBJECT_TYPE_VDB = 21;
    private static HashMap objectTypeMap = new HashMap();
    protected String identifier;
    protected String[] identifierParts;
    protected String name;
    private Properties props = new Properties();
    private Date created;
    private String createdBy = "<default>";
    private Date lastUpdated;
    private String lastUpdatedBy = "<default>";
    protected boolean deployed;
    protected boolean registered;
    protected boolean enabled;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Session;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$LogConfiguration;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$VDB;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$SystemObject;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Cache;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$SourceRequest;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ConnectionPool;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Host;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Model;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$QueueWorkerPool;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$PropertyDefinition;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ExtensionModule;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Group;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Entitlement;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$User;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ConnectorType;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ProcessObject;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Role;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Resource;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Request;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ConnectorBinding;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$DQP;

    public MMAdminObject(String[] identifierParts) {
        if (identifierParts == null) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("AbstractAdminObject.0"));
        }
        if (identifierParts.length == 0) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("AbstractAdminObject.1"));
        }
        this.setIdentifier(identifierParts);
    }

    public String getName() {
        return this.name;
    }

    protected static List buildIdentifierList(String identifier) {
        ArrayList<String> result = null;
        if (identifier.indexOf(124) != -1) {
            result = StringUtil.split(identifier, DELIMITER);
        } else {
            result = new ArrayList<String>(1);
            result.add(identifier);
        }
        return result;
    }

    public static String[] buildIdentifierArray(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public static String getNameFromIdentifier(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        int nameComponentCount = list.size();
        if (nameComponentCount > 0) {
            return (String)list.get(nameComponentCount - 1);
        }
        return null;
    }

    public static String getParentName(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        int nameComponentCount = list.size();
        if (nameComponentCount > 1) {
            return (String)list.get(nameComponentCount - 2);
        }
        return identifier;
    }

    public static String buildIdentifier(String[] identifierParts) {
        StringBuffer results = new StringBuffer();
        int length = identifierParts.length;
        for (int i = 0; i < length - 1; ++i) {
            results.append(identifierParts[i]).append('|');
        }
        results.append(identifierParts[length - 1]);
        return results.toString();
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getPropertiesAsString() {
        String results = "";
        if (this.props != null) {
            results = PropertiesUtils.prettyPrint(this.props);
        }
        return results;
    }

    public void setIdentifier(String[] identifierParts) {
        this.identifier = MMAdminObject.buildIdentifier(identifierParts);
        this.identifierParts = identifierParts;
        this.name = identifierParts[identifierParts.length - 1];
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getIdentifierArray() {
        return this.identifierParts;
    }

    public abstract String toString();

    public Date getCreatedDate() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getLastChangedDate() {
        return this.lastUpdated;
    }

    public String getLastChangedBy() {
        return this.lastUpdatedBy;
    }

    public String getPropertyValue(String name) {
        return this.props.getProperty(name);
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Properties getProps() {
        return this.props;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public static int getObjectType(String className) throws AdminException {
        Integer codeInteger;
        if (className.indexOf(".") == -1) {
            className = OBJECTS_PACKAGE + className;
        }
        if ((codeInteger = (Integer)objectTypeMap.get(className)) == null) {
            String message = AdminPlugin.Util.getString("MMAdminObject.Unsupported_Admin_Object", new Object[]{className});
            throw new AdminProcessingException(message);
        }
        return codeInteger;
    }

    static {
        Class<?> clazz = class$com$metamatrix$admin$api$objects$Cache;
        if (clazz == null) {
            clazz = class$com$metamatrix$admin$api$objects$Cache = new Cache[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz.getName(), new Integer(0));
        Class<?> clazz2 = class$com$metamatrix$admin$api$objects$ConnectionPool;
        if (clazz2 == null) {
            clazz2 = class$com$metamatrix$admin$api$objects$ConnectionPool = new ConnectionPool[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz2.getName(), new Integer(1));
        Class<?> clazz3 = class$com$metamatrix$admin$api$objects$ConnectorBinding;
        if (clazz3 == null) {
            clazz3 = class$com$metamatrix$admin$api$objects$ConnectorBinding = new ConnectorBinding[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz3.getName(), new Integer(2));
        Class<?> clazz4 = class$com$metamatrix$admin$api$objects$ConnectorType;
        if (clazz4 == null) {
            clazz4 = class$com$metamatrix$admin$api$objects$ConnectorType = new ConnectorType[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz4.getName(), new Integer(3));
        Class<?> clazz5 = class$com$metamatrix$admin$api$objects$DQP;
        if (clazz5 == null) {
            clazz5 = class$com$metamatrix$admin$api$objects$DQP = new DQP[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz5.getName(), new Integer(4));
        Class<?> clazz6 = class$com$metamatrix$admin$api$objects$Entitlement;
        if (clazz6 == null) {
            clazz6 = class$com$metamatrix$admin$api$objects$Entitlement = new Entitlement[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz6.getName(), new Integer(5));
        Class<?> clazz7 = class$com$metamatrix$admin$api$objects$ExtensionModule;
        if (clazz7 == null) {
            clazz7 = class$com$metamatrix$admin$api$objects$ExtensionModule = new ExtensionModule[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz7.getName(), new Integer(6));
        Class<?> clazz8 = class$com$metamatrix$admin$api$objects$Group;
        if (clazz8 == null) {
            clazz8 = class$com$metamatrix$admin$api$objects$Group = new Group[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz8.getName(), new Integer(7));
        Class<?> clazz9 = class$com$metamatrix$admin$api$objects$Host;
        if (clazz9 == null) {
            clazz9 = class$com$metamatrix$admin$api$objects$Host = new Host[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz9.getName(), new Integer(8));
        Class<?> clazz10 = class$com$metamatrix$admin$api$objects$LogConfiguration;
        if (clazz10 == null) {
            clazz10 = class$com$metamatrix$admin$api$objects$LogConfiguration = new LogConfiguration[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz10.getName(), new Integer(9));
        Class<?> clazz11 = class$com$metamatrix$admin$api$objects$Model;
        if (clazz11 == null) {
            clazz11 = class$com$metamatrix$admin$api$objects$Model = new Model[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz11.getName(), new Integer(10));
        Class<?> clazz12 = class$com$metamatrix$admin$api$objects$ProcessObject;
        if (clazz12 == null) {
            clazz12 = class$com$metamatrix$admin$api$objects$ProcessObject = new ProcessObject[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz12.getName(), new Integer(11));
        Class<?> clazz13 = class$com$metamatrix$admin$api$objects$PropertyDefinition;
        if (clazz13 == null) {
            clazz13 = class$com$metamatrix$admin$api$objects$PropertyDefinition = new PropertyDefinition[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz13.getName(), new Integer(12));
        Class<?> clazz14 = class$com$metamatrix$admin$api$objects$QueueWorkerPool;
        if (clazz14 == null) {
            clazz14 = class$com$metamatrix$admin$api$objects$QueueWorkerPool = new QueueWorkerPool[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz14.getName(), new Integer(13));
        Class<?> clazz15 = class$com$metamatrix$admin$api$objects$Request;
        if (clazz15 == null) {
            clazz15 = class$com$metamatrix$admin$api$objects$Request = new Request[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz15.getName(), new Integer(14));
        Class<?> clazz16 = class$com$metamatrix$admin$api$objects$Resource;
        if (clazz16 == null) {
            clazz16 = class$com$metamatrix$admin$api$objects$Resource = new Resource[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz16.getName(), new Integer(15));
        Class<?> clazz17 = class$com$metamatrix$admin$api$objects$Role;
        if (clazz17 == null) {
            clazz17 = class$com$metamatrix$admin$api$objects$Role = new Role[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz17.getName(), new Integer(16));
        Class<?> clazz18 = class$com$metamatrix$admin$api$objects$Session;
        if (clazz18 == null) {
            clazz18 = class$com$metamatrix$admin$api$objects$Session = new Session[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz18.getName(), new Integer(17));
        Class<?> clazz19 = class$com$metamatrix$admin$api$objects$SourceRequest;
        if (clazz19 == null) {
            clazz19 = class$com$metamatrix$admin$api$objects$SourceRequest = new SourceRequest[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz19.getName(), new Integer(18));
        Class<?> clazz20 = class$com$metamatrix$admin$api$objects$SystemObject;
        if (clazz20 == null) {
            clazz20 = class$com$metamatrix$admin$api$objects$SystemObject = new SystemObject[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz20.getName(), new Integer(19));
        Class<?> clazz21 = class$com$metamatrix$admin$api$objects$User;
        if (clazz21 == null) {
            clazz21 = class$com$metamatrix$admin$api$objects$User = new User[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz21.getName(), new Integer(20));
        Class<?> clazz22 = class$com$metamatrix$admin$api$objects$VDB;
        if (clazz22 == null) {
            clazz22 = class$com$metamatrix$admin$api$objects$VDB = new VDB[0].getClass().getComponentType();
        }
        objectTypeMap.put(clazz22.getName(), new Integer(21));
    }
}

