/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class VersionHashMap {
    private HashMap internal = new HashMap();

    Object put(VersionSupplier versionSupplier) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(versionSupplier.getName());
        if (existing == null) {
            VersionSupplier[] vss = new VersionSupplier[]{versionSupplier};
            this.internal.put(versionSupplier.getName(), vss);
        } else {
            for (int i = 0; i < existing.length; ++i) {
                VersionSupplier e = existing[i];
                if (e == versionSupplier) {
                    return e;
                }
                if (versionSupplier.getBundle().isResolved() && !e.getBundle().isResolved()) {
                    this.internal.put(versionSupplier.getName(), this.add(i, versionSupplier, existing));
                    return null;
                }
                if (versionSupplier.getBundle().isResolved() != e.getBundle().isResolved()) continue;
                if (versionSupplier.getVersion().compareTo(e.getVersion()) > 0) {
                    this.internal.put(versionSupplier.getName(), this.add(i, versionSupplier, existing));
                    return null;
                }
                if (!e.getVersion().equals(versionSupplier.getVersion()) || versionSupplier.getBundle().getBundleId() >= e.getBundle().getBundleId()) continue;
                this.internal.put(versionSupplier.getName(), this.add(i, versionSupplier, existing));
                return e;
            }
            this.internal.put(versionSupplier.getName(), this.add(existing.length, versionSupplier, existing));
        }
        return null;
    }

    void put(VersionSupplier[] versionSuppliers) {
        for (int i = 0; i < versionSuppliers.length; ++i) {
            this.put(versionSuppliers[i]);
        }
    }

    private VersionSupplier[] add(int index, VersionSupplier versionSupplier, VersionSupplier[] existing) {
        int i;
        VersionSupplier[] newVS = new VersionSupplier[existing.length + 1];
        for (i = 0; i < index; ++i) {
            newVS[i] = existing[i];
        }
        newVS[index] = versionSupplier;
        for (i = index + 1; i < newVS.length; ++i) {
            newVS[i] = existing[i - 1];
        }
        return newVS;
    }

    VersionSupplier[] getArray(String supplierName) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(supplierName);
        if (existing != null) {
            return existing;
        }
        return new VersionSupplier[0];
    }

    boolean contains(VersionSupplier vs) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(vs.getName());
        if (existing == null) {
            return false;
        }
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] != vs) continue;
            return true;
        }
        return false;
    }

    private void remove(VersionSupplier[] existing, String name, int index) {
        if (existing.length == 1) {
            this.internal.remove(name);
        } else {
            int i;
            VersionSupplier[] newVS = new VersionSupplier[existing.length - 1];
            for (i = 0; i < index; ++i) {
                newVS[i] = existing[i];
            }
            for (i = index + 1; i < existing.length; ++i) {
                newVS[i - 1] = existing[i];
            }
            this.internal.put(name, newVS);
        }
    }

    Object remove(VersionSupplier toBeRemoved) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(toBeRemoved.getName());
        if (existing != null) {
            for (int i = 0; i < existing.length; ++i) {
                if (toBeRemoved != existing[i]) continue;
                this.remove(existing, toBeRemoved.getName(), i);
                return toBeRemoved;
            }
        }
        return null;
    }

    void remove(VersionSupplier[] versionSuppliers) {
        for (int i = 0; i < versionSuppliers.length; ++i) {
            this.remove(versionSuppliers[i]);
        }
    }

    void reorder() {
        Iterator it = this.internal.values().iterator();
        while (it.hasNext()) {
            int i;
            ArrayList<VersionSupplier> toBeReordered = new ArrayList<VersionSupplier>();
            VersionSupplier[] existing = (VersionSupplier[])it.next();
            if (existing == null || existing.length <= 1) continue;
            VersionSupplier vs1 = existing[0];
            for (i = 1; i < existing.length; ++i) {
                int versionDiff;
                VersionSupplier vs2 = existing[i];
                BundleDescription b1 = vs1.getBundle();
                BundleDescription b2 = vs2.getBundle();
                if (b2.isResolved() && !b1.isResolved()) {
                    toBeReordered.add(vs2);
                } else if (b2.isResolved() == b1.isResolved() && ((versionDiff = vs2.getVersion().compareTo(vs1.getVersion())) > 0 || b2.getBundleId() < b1.getBundleId() && versionDiff == 0)) {
                    toBeReordered.add(vs2);
                }
                vs1 = vs2;
            }
            for (i = 0; i < toBeReordered.size(); ++i) {
                VersionSupplier vs = (VersionSupplier)toBeReordered.get(i);
                this.remove(vs);
                this.put(vs);
            }
        }
    }
}

