/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.protocol.bundleresource.Handler;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.util.NLS;

public abstract class BundleFile {
    static final SecureAction secureAction = new SecureAction();
    protected File basefile;

    public BundleFile() {
    }

    public BundleFile(File basefile) {
        this.basefile = basefile;
    }

    public abstract File getFile(String var1);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public URL getResourceURL(String path, long hostBundleID) {
        return this.getResourceURL(path, hostBundleID, 0);
    }

    public URL getResourceURL(String path, long hostBundleID, int index) {
        BundleEntry bundleEntry = this.getEntry(path);
        if (bundleEntry == null) {
            return null;
        }
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return secureAction.getURL("bundleresource", Long.toString(hostBundleID), index, path, new Handler(bundleEntry));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public File getBaseFile() {
        return this.basefile;
    }

    public static class NestedDirBundleFile
    extends BundleFile {
        BundleFile baseBundleFile;
        String cp;

        public NestedDirBundleFile(BundleFile baseBundlefile, String cp) {
            super(baseBundlefile.basefile);
            this.baseBundleFile = baseBundlefile;
            this.cp = cp;
            if (cp.charAt(cp.length() - 1) != '/') {
                this.cp = this.cp + '/';
            }
        }

        public void close() {
        }

        public BundleEntry getEntry(String path) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            String newpath = new StringBuffer(this.cp).append(path).toString();
            return this.baseBundleFile.getEntry(newpath);
        }

        public boolean containsDir(String dir) {
            if (dir == null) {
                return false;
            }
            if (dir.length() > 0 && dir.charAt(0) == '/') {
                dir = dir.substring(1);
            }
            String newdir = new StringBuffer(this.cp).append(dir).toString();
            return this.baseBundleFile.containsDir(newdir);
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public File getFile(String entry) {
            return null;
        }

        public void open() throws IOException {
        }
    }

    public static class DirBundleFile
    extends BundleFile {
        public DirBundleFile(File basefile) throws IOException {
            super(basefile);
            if (!secureAction.exists(basefile) || !secureAction.isDirectory(basefile)) {
                throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_EXCEPTION, basefile));
            }
        }

        public File getFile(String path) {
            File filePath = new File(this.basefile, path);
            if (secureAction.exists(filePath)) {
                return filePath;
            }
            return null;
        }

        public BundleEntry getEntry(String path) {
            File filePath = new File(this.basefile, path);
            if (!secureAction.exists(filePath)) {
                return null;
            }
            return new BundleEntry.FileBundleEntry(filePath, path);
        }

        public boolean containsDir(String dir) {
            File dirPath = new File(this.basefile, dir);
            return secureAction.exists(dirPath) && secureAction.isDirectory(dirPath);
        }

        public Enumeration getEntryPaths(final String path) {
            final File pathFile = new File(this.basefile, path);
            if (!secureAction.exists(pathFile)) {
                return new Enumeration(){

                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        throw new NoSuchElementException();
                    }
                };
            }
            if (secureAction.isDirectory(pathFile)) {
                final String[] fileList = secureAction.list(pathFile);
                final String dirPath = path.length() == 0 || path.charAt(path.length() - 1) == '/' ? path : path + '/';
                return new Enumeration(){
                    int cur = 0;

                    public boolean hasMoreElements() {
                        return fileList != null && this.cur < fileList.length;
                    }

                    public Object nextElement() {
                        if (!this.hasMoreElements()) {
                            throw new NoSuchElementException();
                        }
                        File childFile = new File(pathFile, fileList[this.cur]);
                        StringBuffer sb = new StringBuffer(dirPath).append(fileList[this.cur++]);
                        if (secureAction.isDirectory(childFile)) {
                            sb.append("/");
                        }
                        return sb.toString();
                    }
                };
            }
            return new Enumeration(){
                int cur = 0;

                public boolean hasMoreElements() {
                    return this.cur < 1;
                }

                public Object nextElement() {
                    if (this.cur == 0) {
                        this.cur = 1;
                        return path;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        public void close() {
        }

        public void open() {
        }
    }

    public static class ZipBundleFile
    extends BundleFile {
        protected BundleData bundledata;
        protected ZipFile zipFile;
        protected boolean closed = true;

        public ZipBundleFile(File basefile, BundleData bundledata) throws IOException {
            super(basefile);
            if (!secureAction.exists(basefile)) {
                throw new IOException(NLS.bind(AdaptorMsg.ADAPTER_FILEEXIST_EXCEPTION, basefile));
            }
            this.bundledata = bundledata;
            this.closed = true;
        }

        protected boolean checkedOpen() {
            try {
                return this.getZipFile() != null;
            }
            catch (IOException e) {
                AbstractBundleData abstractData = (AbstractBundleData)this.bundledata;
                abstractData.getAdaptor().getEventPublisher().publishFrameworkEvent(2, abstractData.getBundle(), e);
                return false;
            }
        }

        protected ZipFile basicOpen() throws IOException {
            return secureAction.getZipFile(this.basefile);
        }

        protected ZipFile getZipFile() throws IOException {
            if (this.closed) {
                this.zipFile = this.basicOpen();
                this.closed = false;
            }
            return this.zipFile;
        }

        private ZipEntry getZipEntry(String path) {
            ZipEntry dirEntry;
            ZipEntry entry;
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if ((entry = this.zipFile.getEntry(path)) != null && entry.getSize() == 0L && !entry.isDirectory() && (dirEntry = this.zipFile.getEntry(path + '/')) != null) {
                entry = dirEntry;
            }
            return entry;
        }

        protected File extractDirectory(String dirName) {
            if (!this.checkedOpen()) {
                return null;
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(dirName) || entryPath.endsWith("/")) continue;
                this.getFile(entryPath);
            }
            return this.getExtractFile(dirName);
        }

        private File getExtractFile(String entryName) {
            File parentPath;
            File childPath;
            if (!(this.bundledata instanceof AbstractBundleData)) {
                return null;
            }
            String path = ".cp";
            String name = entryName.replace('/', File.separatorChar);
            path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : path + File.separator + name;
            File childGenDir = ((AbstractBundleData)this.bundledata).getGenerationDir();
            if (childGenDir != null && (childPath = new File(childGenDir, path)).exists()) {
                return childPath;
            }
            File parentGenDir = ((AbstractBundleData)this.bundledata).getParentGenerationDir();
            if (parentGenDir != null && (parentPath = new File(parentGenDir, path)).exists()) {
                return parentPath;
            }
            File bundleGenerationDir = ((AbstractBundleData)this.bundledata).createGenerationDir();
            if (bundleGenerationDir != null && bundleGenerationDir.exists()) {
                return new File(bundleGenerationDir, path);
            }
            return null;
        }

        public File getFile(String entry) {
            block16: {
                if (!this.checkedOpen()) {
                    return null;
                }
                ZipEntry zipEntry = this.getZipEntry(entry);
                if (zipEntry == null) {
                    return null;
                }
                try {
                    File nested = this.getExtractFile(zipEntry.getName());
                    if (nested != null) {
                        if (nested.exists()) {
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("File already present: " + nested.getPath());
                            }
                        } else if (zipEntry.getName().endsWith("/")) {
                            if (!nested.mkdirs()) {
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println("Unable to create directory: " + nested.getPath());
                                }
                                throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, nested.getAbsolutePath()));
                            }
                            this.extractDirectory(zipEntry.getName());
                        } else {
                            File dir;
                            InputStream in = this.zipFile.getInputStream(zipEntry);
                            if (in == null) {
                                return null;
                            }
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("Creating file: " + nested.getPath());
                            }
                            if (!(dir = new File(nested.getParent())).exists() && !dir.mkdirs()) {
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println("Unable to create directory: " + dir.getPath());
                                }
                                throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, dir.getAbsolutePath()));
                            }
                            AbstractFrameworkAdaptor.readFile(in, nested);
                        }
                        return nested;
                    }
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_GENERAL) break block16;
                    Debug.printStackTrace(e);
                }
            }
            return null;
        }

        public boolean containsDir(String dir) {
            if (!this.checkedOpen()) {
                return false;
            }
            if (dir == null) {
                return false;
            }
            if (dir.length() == 0) {
                return true;
            }
            if (dir.charAt(0) == '/') {
                if (dir.length() == 1) {
                    return true;
                }
                dir = dir.substring(1);
            }
            if (dir.length() > 0 && dir.charAt(dir.length() - 1) != '/') {
                dir = dir + '/';
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(dir)) continue;
                return true;
            }
            return false;
        }

        public BundleEntry getEntry(String path) {
            if (!this.checkedOpen()) {
                return null;
            }
            ZipEntry zipEntry = this.getZipEntry(path);
            if (zipEntry == null) {
                if ((path.length() == 0 || path.charAt(path.length() - 1) == '/') && this.containsDir(path)) {
                    return new BundleEntry.DirZipBundleEntry(this, path);
                }
                return null;
            }
            return new BundleEntry.ZipBundleEntry(zipEntry, this);
        }

        public Enumeration getEntryPaths(String path) {
            if (!this.checkedOpen()) {
                return null;
            }
            if (path == null) {
                throw new NullPointerException();
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                path = new StringBuffer(path).append("/").toString();
            }
            Vector<String> vEntries = new Vector<String>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
                if (entryPath.lastIndexOf(47) < path.length()) {
                    vEntries.add(entryPath);
                    continue;
                }
                entryPath = entryPath.substring(path.length());
                int slash = entryPath.indexOf(47);
                entryPath = path + entryPath.substring(0, slash + 1);
                if (vEntries.contains(entryPath)) continue;
                vEntries.add(entryPath);
            }
            return vEntries.elements();
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.zipFile.close();
            }
        }

        public void open() {
        }
    }
}

