/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.query.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.ServerListenerRegistrant;
import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.ClientConnectionWithConnectionIdObject;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.platform.server.ClientConnectionImpl;
import com.metamatrix.common.comm.platform.server.FilteringMessageServiceAgent;
import com.metamatrix.common.comm.platform.socket.SocketLogon;
import com.metamatrix.common.comm.platform.socket.StartSessionMessage;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.DefaultTerminalServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.dqp.application.DQP;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import com.metamatrix.dqp.message.CancelMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.platform.admin.api.IServerLogonSource;
import com.metamatrix.platform.resource.MessageReceiver;
import com.metamatrix.platform.resource.RemoteResource;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.IServerLogon;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.TrustedSessionToken;
import com.metamatrix.platform.service.api.CacheAdmin;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.query.service.BaseQueryServiceInterface;
import com.metamatrix.server.serverapi.RequestInfo;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class QueryServiceEngine
implements SocketService,
ServerListenerRegistrant,
RemoteResource,
ServerListener,
BaseQueryServiceInterface,
CacheAdmin {
    private static final String CODE_TABLE_CACHE_NAME = "CodeTableCache";
    private static final String PLAN_CACHE_NAME = "PreparedPlanCache";
    private static final String RESULT_SET_CACHE_NAME = "QueryServiceResultSetCache";
    private DQP dqp;
    private Map clientConnectionToSession = Collections.synchronizedMap(new HashMap());
    private IServerLogonSource serverLogonSource;
    private ServerListener listenerFilter;
    private ServerListenerRegistry registry = null;
    private Random random = new Random();

    public void initialize(DQP dqp, IServerLogonSource sessionService) {
        this.dqp = dqp;
        this.serverLogonSource = sessionService;
        this.listenerFilter = new FilteringMessageServiceAgent(ILogon.class, new ServiceInterceptor[0], new DefaultTerminalServiceInterceptor(new SocketLogon(sessionService.getIServerLogon(), null)), this);
    }

    protected void closeService() throws ApplicationLifecycleException {
        this.dqp.stop();
        this.clientConnectionToSession.clear();
    }

    protected void waitForServiceToClear() throws Exception {
    }

    protected void killService() {
        try {
            this.closeService();
        }
        catch (ApplicationLifecycleException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    public void clearCache(SessionToken sessionToken) throws ComponentNotFoundException, ServiceStateException, RemoteException {
        List connections = this.getClientConnections(sessionToken.getSessionID());
        for (ClientConnection connection : connections) {
            this.clientConnectionToSession.remove(connection);
        }
    }

    public Collection getAllQueries() throws ServiceStateException, RemoteException {
        AdminRequestMessage aRequest = new AdminRequestMessage();
        aRequest.setRequestType(0);
        return this.getQueries(aRequest);
    }

    public void cancelQueries(SessionToken sessionToken, boolean shouldRollback) throws ServiceStateException, InvalidRequestIDException, MetaMatrixComponentException, RemoteException {
        List connections = this.getClientConnections(sessionToken.getSessionID());
        for (ClientConnection connection : connections) {
            CancelMessage cancelMsg = new CancelMessage();
            cancelMsg.assignToClientConnection(connection);
            try {
                this.dqp.receive(connection, (Message)cancelMsg);
            }
            catch (ApplicationException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
        }
    }

    public Collection getQueriesForSession(SessionToken userToken) throws ServiceStateException, RemoteException {
        ClientConnection clientConn = this.getOneClientConnection(userToken.getSessionID());
        if (clientConn != null) {
            AdminRequestMessage aRequest = new AdminRequestMessage();
            aRequest.setRequestType(1);
            aRequest.assignToClientConnection(clientConn);
            aRequest.setUserParameters(clientConn);
            return this.getQueries(aRequest);
        }
        return Collections.EMPTY_SET;
    }

    public void cancelQuery(RequestID requestID, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceStateException, RemoteException {
        CancelMessage cancelMsg = new CancelMessage();
        cancelMsg.setRequestID(requestID);
        Properties props = new Properties();
        props.setProperty("connectionID", requestID.getConnectionID());
        try {
            this.dqp.receive(this.createClientConnection(props), (Message)cancelMsg);
        }
        catch (ApplicationException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
    }

    public void cancelQuery(RequestID requestID, int nodeID) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceStateException, RemoteException {
        CancelMessage cancelMsg = new CancelMessage();
        cancelMsg.setRequestID(requestID);
        cancelMsg.setNodeID(nodeID);
        Properties props = new Properties();
        props.setProperty("connectionID", requestID.getConnectionID());
        try {
            this.dqp.receive(this.createClientConnection(props), (Message)cancelMsg);
        }
        catch (ApplicationException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
    }

    private SessionToken validateSession(MetaMatrixSessionID sessionID) throws MetaMatrixRuntimeException {
        SessionToken token = null;
        try {
            IServerLogon proxy = this.getIServerLogon();
            token = proxy.validateSessionHighLevel(sessionID);
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (ComponentNotFoundException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        return token;
    }

    private IServerLogon getIServerLogon() {
        return this.serverLogonSource.getIServerLogon();
    }

    private Collection getQueries(AdminRequestMessage aRequest) {
        AdminResultsMessage result = null;
        try {
            ClientConnection clientConn = aRequest.getClientConnection();
            if (clientConn == null) {
                clientConn = this.createEmptyClientConnection();
            }
            result = (AdminResultsMessage)this.dqp.receive(clientConn, (Message)aRequest);
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e.getMessage());
        }
        Collection results = result.getResults();
        HashSet<RequestInfo> queries = null;
        if (results != null && results.size() > 0) {
            queries = new HashSet<RequestInfo>();
            Map reqsMap = (Map)results.iterator().next();
            for (RequestMessage rMsg : reqsMap.keySet()) {
                RequestInfo info = new RequestInfo(rMsg, rMsg.getCommand().toString());
                SessionToken st = (SessionToken)this.clientConnectionToSession.get(rMsg.getClientConnection());
                info.setSessionToken(st);
                queries.add(info);
                Collection atomicqueries = (Collection)reqsMap.get(rMsg);
                if (atomicqueries == null || atomicqueries.size() <= 0) continue;
                for (RequestMessage aMsg : atomicqueries) {
                    RequestInfo ainfo = new RequestInfo(aMsg, aMsg.getCommand().toString());
                    ainfo.setSessionToken(st);
                    queries.add(ainfo);
                }
            }
            return queries;
        }
        return Collections.EMPTY_SET;
    }

    private ClientConnection createClientConnection(Properties props) {
        return new ClientConnectionImpl(null, props);
    }

    private ClientConnection createEmptyClientConnection() {
        return new ClientConnectionImpl(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getClientConnections(MetaMatrixSessionID sessionID) {
        Map map = this.clientConnectionToSession;
        synchronized (map) {
            ArrayList results = new ArrayList();
            for (Object client : this.clientConnectionToSession.keySet()) {
                SessionToken token = (SessionToken)this.clientConnectionToSession.get(client);
                if (!token.getSessionID().equals(sessionID)) continue;
                results.add(client);
            }
            return results;
        }
    }

    protected ClientConnection getOneClientConnection(MetaMatrixSessionID sessionID) {
        List list = this.getClientConnections(sessionID);
        int index = this.random.nextInt(list.size());
        return (ClientConnection)list.get(index);
    }

    public Collection getQueueStatistics() {
        AdminRequestMessage aRequest = new AdminRequestMessage();
        aRequest.setRequestType(2);
        AdminResultsMessage result = null;
        try {
            if (this.dqp != null) {
                result = (AdminResultsMessage)this.dqp.receive(this.createEmptyClientConnection(), (Message)aRequest);
            }
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e.getMessage());
        }
        Collection results = new ArrayList();
        if (result != null) {
            results = result.getResults();
        }
        return results;
    }

    public WorkerPoolStats getQueueStatistics(String name) {
        Object aPoolStat;
        Iterator resultsItr;
        AdminRequestMessage aRequest = new AdminRequestMessage(name);
        aRequest.setRequestType(3);
        AdminResultsMessage result = null;
        try {
            if (this.dqp != null) {
                result = (AdminResultsMessage)this.dqp.receive(this.createEmptyClientConnection(), (Message)aRequest);
            }
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e.getMessage());
        }
        Collection results = null;
        WorkerPoolStats poolStats = new WorkerPoolStats();
        if (result != null && (results = result.getResults()) != null && (resultsItr = results.iterator()).hasNext() && (aPoolStat = resultsItr.next()) != null && aPoolStat instanceof WorkerPoolStats) {
            poolStats = (WorkerPoolStats)aPoolStat;
        }
        return poolStats;
    }

    public Map getCaches() throws MetaMatrixComponentException {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(CODE_TABLE_CACHE_NAME, CODE_TABLE_CACHE_NAME);
        names.put(PLAN_CACHE_NAME, PLAN_CACHE_NAME);
        names.put(RESULT_SET_CACHE_NAME, RESULT_SET_CACHE_NAME);
        return names;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearCache(String name, Properties props) throws MetaMatrixComponentException {
        if (name.equals(CODE_TABLE_CACHE_NAME)) {
            AdminRequestMessage aRequest = new AdminRequestMessage();
            aRequest.setRequestType(4);
            try {
                if (this.dqp == null) return;
                this.dqp.receive(this.createEmptyClientConnection(), (Message)aRequest);
                return;
            }
            catch (ApplicationException e) {
                throw new MetaMatrixRuntimeException(e.getMessage());
            }
        }
        if (name.equals(PLAN_CACHE_NAME)) {
            AdminRequestMessage aRequest = new AdminRequestMessage();
            aRequest.setRequestType(5);
            try {
                if (this.dqp == null) return;
                this.dqp.receive(this.createEmptyClientConnection(), (Message)aRequest);
                return;
            }
            catch (ApplicationException e) {
                throw new MetaMatrixRuntimeException(e.getMessage());
            }
        }
        if (!name.equals(RESULT_SET_CACHE_NAME)) return;
        AdminRequestMessage aRequest = new AdminRequestMessage();
        aRequest.setRequestType(6);
        try {
            if (this.dqp == null) return;
            this.dqp.receive(this.createEmptyClientConnection(), (Message)aRequest);
            return;
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e.getMessage());
        }
    }

    private void associateSessionToConnection(ClientConnectionWithConnectionIdObject connection, MetaMatrixSessionID sessionID) {
        SessionToken token = this.validateSession(sessionID);
        this.clientConnectionToSession.put(connection, token);
    }

    public void connectionAdded(ClientConnection plainClientConnection) {
        ClientConnectionWithConnectionIdObject connection = (ClientConnectionWithConnectionIdObject)plainClientConnection;
        MetaMatrixSessionID sessionID = (MetaMatrixSessionID)connection.getConnectionIdObject();
        if (sessionID != null) {
            this.associateSessionToConnection(connection, sessionID);
        }
        this.dqp.connectionAdded((ClientConnection)connection);
    }

    public void connectionRemoved(ClientConnection plainClientConnection) {
        ClientConnectionWithConnectionIdObject connection = (ClientConnectionWithConnectionIdObject)plainClientConnection;
        if (connection != null) {
            this.clientConnectionToSession.remove(plainClientConnection);
            this.dqp.connectionRemoved((ClientConnection)connection);
        }
    }

    public void receive(ClientConnection plainClientConnection, Message message, String messageKey) {
        ClientConnectionWithConnectionIdObject connection = (ClientConnectionWithConnectionIdObject)plainClientConnection;
        MetaMatrixSessionID sessionID = (MetaMatrixSessionID)connection.getConnectionIdObject();
        SessionToken token = this.validateSession(sessionID);
        if (message instanceof DQPInboundMessage && token instanceof TrustedSessionToken) {
            Serializable sessionPayload = ((TrustedSessionToken)token).getTrustedToken();
            connection.setSessionPayload(sessionPayload);
        }
        this.dqp.receive((ClientConnection)connection, message, messageKey);
    }

    public Message receive(ClientConnection plainClientConnection, Message message) throws ApplicationException {
        ClientConnectionWithConnectionIdObject connection = (ClientConnectionWithConnectionIdObject)plainClientConnection;
        if (message instanceof StartSessionMessage) {
            StartSessionMessage startSessionMessage = (StartSessionMessage)message;
            MetaMatrixSessionID sessionID = (MetaMatrixSessionID)startSessionMessage.getSessionId();
            this.associateSessionToConnection(connection, sessionID);
            return null;
        }
        MetaMatrixSessionID sessionID = (MetaMatrixSessionID)connection.getConnectionIdObject();
        this.validateSession(sessionID);
        return this.dqp.receive(plainClientConnection, message);
    }

    public Message send(Message message, Object clientIdentifier) throws ApplicationException, RemoteException {
        MetaMatrixSessionID sessionID = (MetaMatrixSessionID)clientIdentifier;
        ClientConnection clientConn = this.getOneClientConnection(sessionID);
        if (ServerPlugin.DEBUG) {
            Object connID = "NoClientConnectionForSession";
            if (clientConn != null) {
                connID = clientConn.getConnectionProperty("connectionID");
            }
            Object[] params = new Object[]{sessionID, connID, message};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("QueryService.send_sync", params));
        }
        if (clientConn == null) {
            return null;
        }
        return this.listenerFilter.receive(clientConn, message);
    }

    public void send(Message message, String messageKey, Object clientIdentifier) throws RemoteException {
        MetaMatrixSessionID sessionID = (MetaMatrixSessionID)clientIdentifier;
        this.validateSession(sessionID);
        ClientConnection clientConn = this.getOneClientConnection(sessionID);
        if (ServerPlugin.DEBUG) {
            Object connID = "NoClientConnectionForSession";
            if (clientConn != null) {
                connID = clientConn.getConnectionProperty("connectionID");
            }
            Object[] params = new Object[]{sessionID, connID, message};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("QueryService.send_async", params));
        }
        if (clientConn == null) {
            return;
        }
        this.dqp.receive(clientConn, message, messageKey);
    }

    public void setMessageReceiver(MessageReceiver receiver, Properties props, Object clientIdentifier) throws RemoteException {
        ClientConnectionImpl clientConn = new ClientConnectionImpl(receiver, props, clientIdentifier);
        if (ServerPlugin.DEBUG) {
            Object[] params = new Object[]{clientIdentifier, receiver, props};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("QueryService.setMessageReceiver", params));
        }
        this.listenerFilter.connectionAdded(clientConn);
    }

    public void clientShutdown(Object clientIdentifier) throws RemoteException {
        MetaMatrixSessionID sessionID = (MetaMatrixSessionID)clientIdentifier;
        List connections = this.getClientConnections(sessionID);
        for (ClientConnection connection : connections) {
            this.listenerFilter.connectionRemoved(connection);
        }
    }

    public void setServerListenerRegistry(ServerListenerRegistry registry) {
        this.registry = registry;
        registry.setServerListener(this.listenerFilter);
    }

    public String getHost() throws RemoteException {
        return this.registry.getHost();
    }

    public int getPort() throws RemoteException {
        return this.registry.getPort();
    }

    public InetAddress getInetAddress() throws RemoteException {
        return this.registry.getInetAddress();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("QueryServiceEngine: ");
        result.append(" Host:");
        try {
            result.append(this.getHost());
        }
        catch (RemoteException err) {
            // empty catch block
        }
        result.append(" Port:");
        try {
            result.append(this.getPort());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result.toString();
    }
}

