/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.Collection;

public class SubqueryFromClause
extends FromClause
implements SubqueryContainer {
    private String name;
    private GroupSymbol symbol;
    private Command command;

    public SubqueryFromClause(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name;
        this.symbol = new GroupSymbol(name);
    }

    public SubqueryFromClause(String name, Command command) {
        this(name);
        this.command = command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getName() {
        return this.name;
    }

    public GroupSymbol getGroupSymbol() {
        return this.symbol;
    }

    public void collectGroups(Collection groups) {
        groups.add(this.getGroupSymbol());
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        SubqueryFromClause sfc = (SubqueryFromClause)obj;
        return this.getName().equalsIgnoreCase(sfc.getName()) && sfc.isOptional() == this.isOptional();
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        return this.name.toUpperCase().hashCode();
    }

    public Object clone() {
        Command commandCopy = null;
        if (this.command != null) {
            commandCopy = (Command)this.command.clone();
        }
        SubqueryFromClause clause = new SubqueryFromClause(this.name, commandCopy);
        Object metadataID = this.symbol.getMetadataID();
        if (metadataID != null) {
            clause.symbol.setMetadataID(metadataID);
        }
        clause.setOptional(this.isOptional());
        return clause;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

