/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.AbstractSetCriteria;
import com.metamatrix.query.sql.lang.CollectionValueIterator;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.util.ValueIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SetCriteria
extends AbstractSetCriteria {
    private Collection values;

    public SetCriteria() {
    }

    public SetCriteria(Expression expression, Collection values) {
        this.set(expression, values);
    }

    public int getNumberOfValues() {
        return this.values != null ? this.values.size() : 0;
    }

    public List getValues() {
        return this.values != null ? new ArrayList(this.values) : Collections.EMPTY_LIST;
    }

    public void setValues(Collection values) {
        this.values = values;
    }

    public ValueIterator getValueIterator() {
        return new CollectionValueIterator(this.values);
    }

    public void setValueIterator(ValueIterator valueIterator) {
    }

    public void set(Expression expression, Collection values) {
        this.setExpression(expression);
        this.setValues(values);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getExpression());
        hc = HashCodeUtil.expHashCode(hc, this.getValues());
        return hc;
    }

    public boolean equals(Object obj) {
        HashSet otherValues;
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        SetCriteria sc = (SetCriteria)obj;
        if (this.isNegated() ^ sc.isNegated()) {
            return false;
        }
        HashSet thisValues = new HashSet(this.getValues());
        return thisValues.equals(otherValues = new HashSet(sc.getValues())) && EquivalenceUtil.areEqual(this.getExpression(), sc.getExpression());
    }

    public Object clone() {
        Expression copy = null;
        if (this.getExpression() != null) {
            copy = (Expression)this.getExpression().clone();
        }
        ArrayList<Object> copyValues = new ArrayList<Object>();
        if (this.getValues() != null) {
            for (Expression e : this.getValues()) {
                copyValues.add(e.clone());
            }
        }
        SetCriteria criteriaCopy = new SetCriteria(copy, copyValues);
        criteriaCopy.setNegated(this.isNegated());
        return criteriaCopy;
    }
}

