/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.symbol.Expression;
import java.util.Arrays;

public class MatchCriteria
extends PredicateCriteria {
    public static final char WILDCARD_CHAR = '%';
    public static final char MATCH_CHAR = '_';
    private Expression leftExpression;
    private Expression rightExpression;
    public static final char NULL_ESCAPE_CHAR = '\u0000';
    private char escapeChar = '\u0000';
    private boolean negated = false;

    public MatchCriteria() {
    }

    public MatchCriteria(Expression leftExpression, Expression rightExpression) {
        this.setLeftExpression(leftExpression);
        this.setRightExpression(rightExpression);
    }

    public MatchCriteria(Expression leftExpression, Expression rightExpression, char escapeChar) {
        this(leftExpression, rightExpression);
        this.setEscapeChar(escapeChar);
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negationFlag) {
        this.negated = negationFlag;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getLeftExpression());
        hc = HashCodeUtil.hashCode(hc, this.getRightExpression());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        MatchCriteria mc = (MatchCriteria)obj;
        if (this.isNegated() ^ mc.isNegated()) {
            return false;
        }
        return this.getEscapeChar() == mc.getEscapeChar() && EquivalenceUtil.areEqual(this.getLeftExpression(), mc.getLeftExpression()) && EquivalenceUtil.areEqual(this.getRightExpression(), mc.getRightExpression());
    }

    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Expression rightCopy = null;
        if (this.getRightExpression() != null) {
            rightCopy = (Expression)this.getRightExpression().clone();
        }
        MatchCriteria criteriaCopy = new MatchCriteria(leftCopy, rightCopy, this.getEscapeChar());
        criteriaCopy.setNegated(this.isNegated());
        return criteriaCopy;
    }

    public static class PatternTranslator {
        private char[] reserved;
        private char newEscape;
        private String newWildCard;
        private String newSingleMatch;

        public PatternTranslator(String newWildCard, String newSingleMatch, char[] reserved, char newEscape) {
            this.reserved = reserved;
            this.newEscape = newEscape;
            this.newSingleMatch = newSingleMatch;
            this.newWildCard = newWildCard;
        }

        public StringBuffer translate(String pattern, char escape) throws CriteriaEvaluationException {
            StringBuffer newPattern = new StringBuffer();
            boolean escaped = false;
            for (int i = 0; i < pattern.length(); ++i) {
                char character = pattern.charAt(i);
                if (character == escape && character != '\u0000') {
                    if (escaped) {
                        this.appendCharacter(newPattern, character);
                        escaped = false;
                        continue;
                    }
                    escaped = true;
                    continue;
                }
                if (character == '%') {
                    if (escaped) {
                        this.appendCharacter(newPattern, character);
                        escaped = false;
                        continue;
                    }
                    newPattern.append(this.newWildCard);
                    continue;
                }
                if (character == '_') {
                    if (escaped) {
                        this.appendCharacter(newPattern, character);
                        escaped = false;
                        continue;
                    }
                    newPattern.append(this.newSingleMatch);
                    continue;
                }
                if (escaped) {
                    throw new CriteriaEvaluationException(QueryPlugin.Util.getString("MatchCriteria.invalid_escape", new Object[]{pattern, new Character(escape)}));
                }
                this.appendCharacter(newPattern, character);
            }
            if (escaped) {
                throw new CriteriaEvaluationException(QueryPlugin.Util.getString("MatchCriteria.invalid_escape", new Object[]{pattern, new Character(escape)}));
            }
            return newPattern;
        }

        private void appendCharacter(StringBuffer newPattern, char character) {
            if (Arrays.binarySearch(this.reserved, character) >= 0) {
                newPattern.append(this.newEscape);
            }
            newPattern.append(character);
        }
    }
}

