/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.jdbc.BaseDataSource;
import com.metamatrix.jdbc.EmbeddedDriver;
import com.metamatrix.jdbc.EmbeddedPooledConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class EmbeddedDataSource
extends BaseDataSource
implements ConnectionPoolDataSource,
XADataSource {
    private String bootstrapFile;
    private int maxStatements;
    private int initialPoolSize;
    private int minPoolSize;
    private int maxPoolSize;
    private int maxIdleTime;
    private int propertyCycle;
    public static final String DQP_BOOTSTRAP_FILE = "bootstrapFile";
    final EmbeddedDriver driver = new EmbeddedDriver();

    protected Properties buildProperties(String userName, String password) {
        Properties props = super.buildProperties(userName, password);
        if (this.getBootstrapFile() != null && this.getBootstrapFile().trim().length() != 0) {
            try {
                props.put(DQP_BOOTSTRAP_FILE, URLHelper.buildURL((String)this.getBootstrapFile().trim()));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return props;
    }

    protected void validateProperties(String userName, String password) throws SQLException {
        String reason;
        super.validateProperties(userName, password);
        if (this.getBootstrapFile() == null && this.getDatabaseName() != null) {
            this.setBootstrapFile(this.driver.getDefaultConnectionURL(this.getDatabaseName()));
        }
        if ((reason = EmbeddedDataSource.reasonWhyInvalidConfigFile(this.bootstrapFile)) != null) {
            throw new SQLException(reason);
        }
    }

    public static String reasonWhyInvalidConfigFile(String configFile) {
        if (configFile == null) {
            return EmbeddedDataSource.getResourceMessage("EmbeddedDataSource.The_configFile_property_is_null");
        }
        try {
            URL url = URLHelper.buildURL((String)configFile);
            url.openStream();
        }
        catch (Exception e) {
            return EmbeddedDataSource.getResourceMessage("EmbeddedDataSource.The_configFile_does_not_exist_or_cant_be_read");
        }
        return null;
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        this.validateProperties(userName, password);
        Properties props = this.buildProperties(userName, password);
        return this.driver.createConnection(props);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        this.validateProperties(user, password);
        Properties props = this.buildProperties(user, password);
        return this.driver.createXAConnection(props);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    public PooledConnection getPooledConnection(String userName, String password) throws SQLException {
        try {
            this.validateProperties(userName, password);
            Properties props = this.buildProperties(userName, password);
            return new EmbeddedPooledConnection(props);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public String getBootstrapFile() {
        return this.bootstrapFile;
    }

    public void setBootstrapFile(String configFile) {
        this.bootstrapFile = configFile;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setPropertyCycle(int propertyCycle) {
        this.propertyCycle = propertyCycle;
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }
}

