/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.text.StringCharacterIterator;

final class WindowsRules {
    private static final int MAX_NAME_LENGTH = 255;

    WindowsRules() {
    }

    public static boolean isFilenameValid(String newName) {
        if (newName == null) {
            return false;
        }
        int length = newName.length();
        if (length == 0 || length > 255) {
            return false;
        }
        StringCharacterIterator charIter = new StringCharacterIterator(newName);
        char c = charIter.first();
        while (c != '\uffff') {
            if (!WindowsRules.isValidCharacter(c)) {
                return false;
            }
            c = charIter.next();
        }
        return true;
    }

    private static boolean isValidCharacter(char c) {
        return c != '\\' && c != '/' && c != ':' && c != '*' && c != '?' && c != '\"' && c != '<' && c != '>' && c != '|';
    }
}

