/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogMessage;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.log.config.LogConfigurationException;
import com.metamatrix.common.log.config.UnmodifiableLogConfiguration;
import com.metamatrix.common.log.format.DelimitedLogMessageFormat;
import com.metamatrix.common.log.format.LogMessageFormat;
import com.metamatrix.core.CorePlugin;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Status;

public final class LogManager {
    public static final String SYSTEM_LOG_CONTEXT_PROPERTY_NAME = "metamatrix.log.contexts";
    public static final String SYSTEM_LOG_CONSOLE_PROPERTY_NAME = "metamatrix.log.console";
    public static final String SYSTEM_LOG_CAPTURE_SYSTEM_OUT = "metamatrix.log.captureSystemOut";
    public static final String SYSTEM_LOG_CAPTURE_SYSTEM_ERR = "metamatrix.log.captureSystemErr";
    public static final String SYSTEM_OUT_FILENAME = "metamatrix.log.systemOutFilename";
    public static final String SYSTEM_ERR_FILENAME = "metamatrix.log.systemErrFilename";
    protected static final String DEFAULT_LOG_MAX_THREADS = "1";
    protected static final String DEFAULT_LOG_THREAD_TTL = "600000";
    protected static final String STANDARD_OUT_CONTEXT = "STDOUT";
    protected static final String STANDARD_ERR_CONTEXT = "STDERR";
    protected static final boolean AUTO_FLUSH = true;
    private static LogManager INSTANCE = new LogManager();
    private static LogConfiguration CONFIGURATION = null;
    private static LogMessageFormat MESSAGE_FORMATTER = new DelimitedLogMessageFormat();
    private static boolean isStopped = true;
    private List initializationMessages = new ArrayList();

    private LogManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LogManager getInstance() {
        if (CONFIGURATION == null) {
            LogManager logManager = INSTANCE;
            synchronized (logManager) {
                INSTANCE.init();
            }
        }
        return INSTANCE;
    }

    private void init() {
        if (CONFIGURATION == null) {
            try {
                LogConfiguration newConfig;
                CONFIGURATION = newConfig = CurrentConfiguration.getConfiguration().getLogConfiguration();
            }
            catch (ConfigurationException e) {
                try {
                    CONFIGURATION = BasicLogConfiguration.createLogConfiguration(System.getProperties());
                }
                catch (LogConfigurationException le) {
                    throw new MetaMatrixRuntimeException((Throwable)le, "ERR.003.014.0005", CommonPlugin.Util.getString("ERR.003.014.0005"));
                }
            }
            isStopped = false;
        }
    }

    public static void logCritical(String context, Object[] msgParts) {
        if (msgParts != null) {
            LogManager.getInstance().logMessage(1, context, msgParts);
        }
    }

    public static void logCritical(String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(1, context, message);
        }
    }

    public static void logCritical(String context, Throwable e, String message) {
        if (e != null) {
            LogManager.getInstance().logMessage(1, context, e, message);
        }
    }

    public static void logCritical(String context, Throwable e, Object[] msgParts) {
        if (e != null) {
            LogManager.getInstance().logMessage(1, context, e, msgParts);
        }
    }

    public static void logError(String context, Object[] msgParts) {
        if (msgParts != null) {
            LogManager.getInstance().logMessage(2, context, msgParts);
        }
    }

    public static void logError(String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(2, context, message);
        }
    }

    public static void logError(String context, Throwable e, String message) {
        LogManager.getInstance().logMessage(2, context, e, message);
    }

    public static void logError(String context, Throwable e, Object[] msgParts) {
        LogManager.getInstance().logMessage(2, context, e, msgParts);
    }

    public static void logWarning(String context, Object[] msgParts) {
        if (msgParts != null) {
            LogManager.getInstance().logMessage(3, context, msgParts);
        }
    }

    public static void logWarning(String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(3, context, message);
        }
    }

    public static void logWarning(String context, Throwable e, String message) {
        LogManager.getInstance().logMessage(3, context, e, message);
    }

    public static void logWarning(String context, Throwable e, Object[] msgParts) {
        LogManager.getInstance().logMessage(3, context, e, msgParts);
    }

    public static void logInfo(String context, Object[] msgParts) {
        if (msgParts != null) {
            LogManager.getInstance().logMessage(4, context, msgParts);
        }
    }

    public static void logInfo(String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(4, context, message);
        }
    }

    public static void logInfo(String context, Throwable e, Object[] msgParts) {
        LogManager.getInstance().logMessage(4, context, e, msgParts);
    }

    public static void logDetail(String context, Object[] msgParts) {
        if (msgParts != null) {
            LogManager.getInstance().logMessage(5, context, msgParts);
        }
    }

    public static void logDetail(String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(5, context, message);
        }
    }

    public static void logDetail(String context, Throwable e, String message) {
        LogManager.getInstance().logMessage(5, context, e, message);
    }

    public static void logDetail(String context, Throwable e, Object[] msgParts) {
        LogManager.getInstance().logMessage(5, context, e, msgParts);
    }

    public static void logTrace(String context, Object[] msgParts) {
        if (msgParts != null) {
            LogManager.getInstance().logMessage(6, context, msgParts);
        }
    }

    public static void logTrace(String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(6, context, message);
        }
    }

    public static void logTrace(String context, Throwable e, String message) {
        LogManager.getInstance().logMessage(6, context, e, message);
    }

    public static void logTrace(String context, Throwable e, Object[] msgParts) {
        LogManager.getInstance().logMessage(6, context, e, msgParts);
    }

    public static void log(int msgLevel, String context, String message) {
        if (message != null) {
            LogManager.getInstance().logMessage(msgLevel, context, message);
        }
    }

    public static void log(int msgLevel, String context, Object[] msgParts) {
        LogManager.getInstance().logMessage(msgLevel, context, msgParts);
    }

    public static void log(int msgLevel, String context, Throwable e, String message) {
        LogManager.getInstance().logMessage(msgLevel, context, e, message);
    }

    public static void printMessage(PrintStream stream, LogMessage msg) {
        if (msg == null) {
            return;
        }
        if (msg.getLevel() > CONFIGURATION.getMessageLevel() || stream == null) {
            return;
        }
        stream.println(MESSAGE_FORMATTER.formatMessage(msg));
    }

    public static void stop() {
        LogManager.logCritical("LOG", CommonPlugin.Util.getString("MSG.003.014.0013"));
        isStopped = true;
        CONFIGURATION = null;
        MESSAGE_FORMATTER = null;
    }

    public static boolean isManagerStopped() {
        return isStopped;
    }

    public static LogConfiguration getLogConfiguration() {
        LogManager.getInstance();
        return CONFIGURATION;
    }

    public static LogConfiguration getLogConfiguration(boolean modifiable) {
        LogManager.getInstance();
        return new BasicLogConfiguration(CONFIGURATION);
    }

    public static void setLogConfiguration(LogConfiguration config) {
        if (config != null) {
            LogManager.logCritical("LOG", CommonPlugin.Util.getString("MSG.003.014.0015", config));
            if (config instanceof UnmodifiableLogConfiguration) {
                UnmodifiableLogConfiguration unmodConfig = (UnmodifiableLogConfiguration)config;
                CONFIGURATION = (LogConfiguration)unmodConfig.deepClone();
            } else {
                CONFIGURATION = new UnmodifiableLogConfiguration((LogConfiguration)config.clone());
            }
        }
    }

    public static boolean isMessageToBeRecorded(String context, int msgLevel) {
        if (context == null) {
            return false;
        }
        if (CONFIGURATION == null) {
            return false;
        }
        if (CONFIGURATION.getMessageLevel() == 0 || msgLevel <= 0 || CONFIGURATION.isLevelDiscarded(msgLevel)) {
            return false;
        }
        return !CONFIGURATION.isContextDiscarded(context);
    }

    public static boolean isMessageToBeRecorded(LogMessage message) {
        if (message == null) {
            return false;
        }
        if (CONFIGURATION == null) {
            return false;
        }
        if (CONFIGURATION.isLevelDiscarded(message.getLevel())) {
            return false;
        }
        return !CONFIGURATION.isContextDiscarded(message.getContext());
    }

    protected void logInitMessage(int level, String context, String message) {
        LogMessage msg = new LogMessage(context, level, new Object[]{message});
        try {
            this.initializationMessages.add(msg);
        }
        catch (Exception e2) {
            LogManager.printMessage(System.out, msg);
            System.err.println(e2.getMessage());
        }
    }

    protected void logInitMessage(int level, String context, Throwable e, String message) {
        LogMessage msg = new LogMessage(context, level, e, new Object[]{message});
        try {
            this.initializationMessages.add(msg);
        }
        catch (Exception e2) {
            LogManager.printMessage(System.out, msg);
            System.err.println(e2.getMessage());
        }
    }

    protected void logMessage(int level, String context, Object[] msgParts) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(context, level, msgParts);
        this.forwardMessage(msg);
    }

    protected void logMessage(int level, String context, String message) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(context, level, new Object[]{message});
        this.forwardMessage(msg);
    }

    protected void logMessage(int level, String context, Throwable e, String message) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(context, level, e, new Object[]{message});
        this.forwardMessage(msg);
    }

    protected void logMessage(int level, String context, Throwable e, Object[] msgParts) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(context, level, e, msgParts);
        this.forwardMessage(msg);
    }

    protected void forwardMessage(LogMessage logMessage) {
        String message = logMessage.getText();
        Throwable t = logMessage.getException();
        int severity = 4;
        int msgLevel = logMessage.getLevel();
        switch (msgLevel) {
            case 1: {
                severity = 4;
                break;
            }
            case 2: {
                severity = 4;
                break;
            }
            case 5: 
            case 6: {
                severity = 1;
                break;
            }
            case 4: {
                severity = 1;
                break;
            }
            case 3: {
                severity = 2;
                break;
            }
            case 0: {
                severity = 0;
            }
        }
        boolean isCode = false;
        Status status = new Status(severity, logMessage.getContext(), 0, message, t);
        CorePlugin.Util.log(status);
    }

    public static Object createLoggingProxy(final String loggingContext, final Object instance, Class[] interfaces, final int level) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                boolean log = LogManager.isMessageToBeRecorded(loggingContext, level);
                if (log) {
                    Object[] msgParts = new Object[args.length * 2 + 3];
                    msgParts[0] = "before";
                    msgParts[1] = method.getName();
                    msgParts[2] = ":";
                    for (int i = 0; i < args.length; ++i) {
                        msgParts[3 + i * 2] = args[i] != null ? args[i] : "null";
                        if (i == args.length - 1) continue;
                        msgParts[4 + i * 2] = ",";
                    }
                    LogManager.log(level, loggingContext, msgParts);
                }
                try {
                    Object result = method.invoke(instance, args);
                    if (log) {
                        LogManager.log(level, loggingContext, new Object[]{"after", method.getName()});
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }
}

