/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.lob.ByteLobChunk;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import java.io.IOException;
import java.io.InputStream;

public class ByteLobChunkStream
implements LobChunkProducer {
    InputStream stream;
    int chunkSize;
    boolean closed = false;

    public ByteLobChunkStream(InputStream stream, int chunkSize) {
        this.stream = stream;
        this.chunkSize = chunkSize;
    }

    public LobChunk getNextChunk() throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CommonPlugin.Util.getString("stream_closed"));
        }
        byte[] cbuf = new byte[this.chunkSize];
        int read = this.stream.read(cbuf);
        if (read > 0 && read < this.chunkSize) {
            byte[] buf = new byte[read];
            System.arraycopy(cbuf, 0, buf, 0, read);
            cbuf = buf;
        } else if (read == -1) {
            return new ByteLobChunk(new byte[0], true);
        }
        return new ByteLobChunk(cbuf, false);
    }

    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }
}

