/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.service;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.service.ILogin;
import com.metamatrix.core.factory.ShortCircuitedFactoryStrategy;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.core.proxy.SecurityContextFactory;
import java.util.Properties;

public class SimpleLoginImpl
implements ILogin {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String SERVER_URL = "serverURL";
    public static final String USER_PROP = "user";
    public static final String PWD_PROP = "password";
    private String serverUrl = "";
    private String userName = "";
    private String password = "";
    private ShortCircuitedFactoryStrategy factoryStrategy;
    Properties connectionProperties = new Properties();

    public SimpleLoginImpl() {
        this.factoryStrategy = new ShortCircuitedFactoryStrategy();
    }

    public void login(String serverUrl, String userName, String password) throws CommunicationException {
        this.serverUrl = serverUrl;
        this.userName = userName;
        this.password = password;
        this.factoryStrategy.setObject(new SecurityContext(userName));
        this.updateConnectionProperties();
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    private void updateConnectionProperties() {
        this.connectionProperties.put(SERVER_URL, this.serverUrl);
        this.connectionProperties.setProperty(USER_PROP, this.userName);
        this.connectionProperties.setProperty(PWD_PROP, this.password);
        try {
            MMURL url = new MMURL(this.serverUrl);
            this.connectionProperties.setProperty(HOST, url.getHosts());
            this.connectionProperties.setProperty(PORT, url.getPorts());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SecurityContextFactory toSecurityContextFactory() {
        return new SecurityContextFactory(this.factoryStrategy);
    }
}

