/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.Handshake;
import com.metamatrix.common.comm.platform.socket.ObjectSocket;
import com.metamatrix.common.comm.platform.socket.SocketClientInstanceStats;
import com.metamatrix.common.comm.platform.socket.SocketConnectionProtocol;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.packet.AsynchronousPacket;
import com.metamatrix.common.comm.platform.socket.packet.ClosingPacket;
import com.metamatrix.common.comm.platform.socket.packet.ConnectionPacket;
import com.metamatrix.common.comm.platform.socket.packet.Packet;
import com.metamatrix.common.comm.platform.socket.packet.SynchronousPacket;
import com.metamatrix.common.comm.platform.socket.server.ServerAsynchronousWorkItem;
import com.metamatrix.common.comm.platform.socket.server.ServerSynchronousWorkItem;
import com.metamatrix.common.comm.platform.socket.server.SocketClientConnection;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import com.metamatrix.common.util.crypto.cipher.SymmetricCryptor;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SocketClientInstance
implements SocketConnectionProtocol {
    private ObjectSocket objectSocket;
    private ServerListener serverListener;
    private SocketLog log;
    private WorkerPool workerPool;
    private static String releaseNumber;
    private SocketClientInstanceStats stats = new SocketClientInstanceStats();
    private static Random random;
    private static final int CHALLENGE_LENGTH = 16;
    private Cryptor cryptor;
    private Map clientConnections = new HashMap();

    public SocketClientInstance(String releaseNumber) {
        SocketClientInstance.releaseNumber = releaseNumber;
    }

    public SocketClientInstance(ObjectSocket objectSocket, ServerListener serverListener, WorkerPool workerPool, SocketLog log, int inputBufferSize, int outputBufferSize) throws CommunicationException, IOException {
        this.objectSocket = objectSocket;
        objectSocket.initialize(this);
        this.serverListener = serverListener;
        this.log = log;
        this.workerPool = workerPool;
    }

    void send(int virtualSocketId, Message message, String messageKey) throws CommunicationException {
        this.objectSocket.write(new AsynchronousPacket(virtualSocketId, messageKey, message));
        ++this.stats.objectsWritten;
    }

    void sendSynchronousResponse(int virtualSocketId, Integer synchRequestId, Message message) throws CommunicationException {
        this.objectSocket.write(new SynchronousPacket(virtualSocketId, synchRequestId, message));
        ++this.stats.objectsWritten;
    }

    private String getVersionInfo() {
        if (releaseNumber == null) {
            releaseNumber = "5.5";
            try {
                ApplicationInfo info = ApplicationInfo.getInstance();
                info.setMainComponent("metamatrix-server.jar");
                ApplicationInfo.Component component = info.getMainComponent();
                releaseNumber = component.getReleaseNumber();
            }
            catch (Throwable t) {
                CommPlatformPlugin.Util.log(1, t.getMessage());
            }
        }
        return releaseNumber;
    }

    public void handshake(Socket socket, ObjectInputStream is, ObjectOutputStream os) throws CommunicationException, IOException {
        try {
            int timeout = socket.getSoTimeout();
            Handshake handshake = new Handshake();
            handshake.setVersion(this.getVersionInfo());
            byte[] sessionChallenge = new byte[16];
            boolean usingEncryption = SocketHelper.isClientEncryptionEnabled();
            if (usingEncryption) {
                random.nextBytes(sessionChallenge);
                handshake.setEncryptor(PasswordCryptoFactory.getSerializableEncryptor());
                handshake.setSessionKey(sessionChallenge);
            }
            socket.setSoTimeout((usingEncryption ? 5 : 1) * 3000);
            os.writeObject(handshake);
            os.flush();
            handshake = (Handshake)is.readObject();
            if (usingEncryption) {
                byte[] returnedSessionKey = PasswordCryptoFactory.getDecryptor().decrypt(handshake.getSessionKey());
                if (returnedSessionKey == null || returnedSessionKey.length != 32) {
                    throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketClientInstance.invalid_sessionkey"));
                }
                byte[] key = new byte[16];
                byte[] returnedSessionChallenge = new byte[16];
                System.arraycopy(returnedSessionKey, 0, returnedSessionChallenge, 0, returnedSessionChallenge.length);
                System.arraycopy(returnedSessionKey, returnedSessionChallenge.length, key, 0, key.length);
                if (!Arrays.equals(returnedSessionChallenge, sessionChallenge)) {
                    throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketClientInstance.invalid_sessionkey"));
                }
                this.cryptor = SymmetricCryptor.getSymmectricCryptor(key);
            } else {
                this.cryptor = new NullCryptor();
            }
            socket.setSoTimeout(timeout);
        }
        catch (ClassNotFoundException e) {
            throw new CommunicationException((Throwable)e, "Handshake Error");
        }
        catch (CryptoException err) {
            throw new CommunicationException((Throwable)err, "Handshake Error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read() {
        try {
            while (true) {
                this.readDirect();
            }
        }
        catch (EOFException e) {
            this.log.logDetail("SocketClientConnection.read", e, "Unable to read: socket was already closed.");
            if (this.objectSocket == null) return;
            try {
                this.objectSocket.close();
                return;
            }
            catch (CommunicationException err) {}
            return;
        }
        catch (CommunicationException e) {
            this.log.logDetail("SocketClientConnection.read", e, "Unable to read: socket was already closed.");
            return;
        }
        catch (Throwable e) {
            this.log.logError("SocketClientConnection.read", e, e.getMessage());
            if (this.objectSocket == null) return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            try {
                this.objectSocket.close();
                return;
            }
            catch (CommunicationException communicationException) {}
            return;
        }
        {
            finally {
                if (this.objectSocket != null) {
                    try {
                        this.objectSocket.close();
                    }
                    catch (CommunicationException err) {}
                }
            }
        }
    }

    protected void readDirect() throws EOFException, CommunicationException {
        Packet rawData = this.objectSocket.read();
        ++this.stats.objectsRead;
        if (rawData instanceof ConnectionPacket) {
            this.processConnectionPacket((ConnectionPacket)rawData);
        } else if (rawData instanceof AsynchronousPacket) {
            this.processAsynchronousPacket((AsynchronousPacket)rawData);
        } else if (rawData instanceof SynchronousPacket) {
            this.processSynchronousPacket((SynchronousPacket)rawData);
        } else if (rawData instanceof ClosingPacket) {
            this.processClosingPacket((ClosingPacket)rawData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processConnectionPacket(ConnectionPacket packet) {
        SocketClientConnection clientConnection = null;
        Map map = this.clientConnections;
        synchronized (map) {
            clientConnection = (SocketClientConnection)this.clientConnections.get(new Integer(packet.virtualSocketID));
            if (clientConnection != null) {
                this.serverListener.connectionRemoved(clientConnection);
            }
            clientConnection = new SocketClientConnection(this, packet.virtualSocketID, packet.properties);
            this.clientConnections.put(new Integer(packet.virtualSocketID), clientConnection);
            this.stats.virtualSockets.add(new Integer(packet.virtualSocketID));
            this.serverListener.connectionAdded(clientConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketClientConnection lookup(int virtualSocketId) {
        Map map = this.clientConnections;
        synchronized (map) {
            return (SocketClientConnection)this.clientConnections.get(new Integer(virtualSocketId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketClientConnection removeFromConnectionMap(int virtualSocketId) {
        Map map = this.clientConnections;
        synchronized (map) {
            this.stats.virtualSockets.remove(new Integer(virtualSocketId));
            return (SocketClientConnection)this.clientConnections.remove(new Integer(virtualSocketId));
        }
    }

    private void processAsynchronousPacket(AsynchronousPacket packet) {
        if (this.log.isLogged("SocketClientConnection.read", 5)) {
            this.log.logDetail("SocketClientConnection.read", "processing asynch message:" + packet.message);
        }
        SocketClientConnection clientConnection = this.lookup(packet.virtualSocketID);
        if (this.deserializationFailed(packet.message)) {
            if (this.log.isLogged("SocketClientConnection.read", 2)) {
                this.log.logError("SocketClientConnection.read", ((ExceptionHolder)((MessageHolder)packet.message).contents).exception, "Exception while deserializing an asynchronous message packet.");
            }
            try {
                clientConnection.send(packet.message, packet.messageKey);
            }
            catch (Throwable t) {
                this.log.logError("SocketClientConnection.read", t, "Exception when sending an asynchronous error packet.");
            }
        } else {
            this.addAsynchWork(clientConnection, packet.message, packet.messageKey);
        }
    }

    private void processSynchronousPacket(SynchronousPacket packet) {
        if (this.log.isLogged("SocketClientConnection.read", 5)) {
            this.log.logDetail("SocketClientConnection.read", "processing synch message:" + packet.message + " virtualSocketId:" + packet.virtualSocketID);
        }
        SocketClientConnection clientConnection = this.lookup(packet.virtualSocketID);
        if (this.deserializationFailed(packet.message)) {
            if (this.log.isLogged("SocketClientConnection.read", 2)) {
                this.log.logError("SocketClientConnection.read", ((ExceptionHolder)((MessageHolder)packet.message).contents).exception, "Exception while deserializing a synchronous message packet.");
            }
            try {
                clientConnection.sendSynchronousResponse(packet.synchRequestID, packet.message);
            }
            catch (Throwable t) {
                this.log.logError("SocketClientConnection.read", t, "Exception when sending a synchronous error packet.");
            }
        } else {
            this.addSynchWork(clientConnection, packet.synchRequestID, packet.message);
        }
    }

    private void processClosingPacket(ClosingPacket data) {
        SocketClientConnection clientConnection = this.removeFromConnectionMap(data.virtualSocketID);
        this.serverListener.connectionRemoved(clientConnection);
    }

    private void addAsynchWork(SocketClientConnection clientConnection, Message message, String messageKey) {
        try {
            this.workerPool.addWork(new ServerAsynchronousWorkItem(clientConnection, this.serverListener, message, messageKey, this.log));
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private void addSynchWork(SocketClientConnection clientConnection, Integer synchRequestId, Message message) {
        try {
            this.workerPool.addWork(new ServerSynchronousWorkItem(clientConnection, synchRequestId, message, this.log, this.serverListener));
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private boolean deserializationFailed(Message message) {
        if (!(message instanceof MessageHolder)) {
            return false;
        }
        MessageHolder holder = (MessageHolder)message;
        Serializable contents = holder.contents;
        if (contents instanceof ExceptionHolder) {
            return true;
        }
        try {
            ((MessageHolder)message).contents = this.cryptor.unsealObject(contents);
        }
        catch (CryptoException err) {
            holder.contents = new ExceptionHolder(err);
            return true;
        }
        return false;
    }

    public SocketClientInstanceStats getStats() {
        return this.stats;
    }

    public Cryptor getCryptor() {
        return this.cryptor;
    }

    public SocketAddress getRemoteAddress() {
        return this.objectSocket.getRemoteAddress();
    }

    static {
        random = new Random();
    }
}

