/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.ScriptsContainer;
import com.metamatrix.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MMScriptsContainer
implements ScriptsContainer {
    private Map fileMap = new HashMap(10);

    public Collection getFileNames() {
        return new ArrayList(this.fileMap.keySet());
    }

    public void saveAllToDirectory(String directoryLocation, AdminOptions options) throws AdminException {
        String fileSeparator = File.separator;
        String path = directoryLocation.endsWith(fileSeparator) ? directoryLocation : directoryLocation + fileSeparator;
        File directory = new File(path);
        if (!directory.isDirectory()) {
            Object[] params = new Object[]{directoryLocation};
            throw new AdminProcessingException(AdminPlugin.Util.getString("MMScriptsContainer.unable_to_locate_directory", params));
        }
        if (!directory.canWrite()) {
            Object[] params = new Object[]{directoryLocation};
            throw new AdminProcessingException(AdminPlugin.Util.getString("MMScriptsContainer.unable_to_write_to_directory", params));
        }
        ArrayList<String> existingFiles = null;
        Iterator fileItr = this.fileMap.keySet().iterator();
        while (fileItr.hasNext()) {
            String fileName = path + (String)fileItr.next();
            File aFile = new File(fileName);
            if (!aFile.exists()) continue;
            if (existingFiles == null) {
                existingFiles = new ArrayList<String>();
            }
            existingFiles.add(fileName);
        }
        if (existingFiles != null && (options == null || options.containsOption(4))) {
            Object[] params = new Object[]{((Object)existingFiles).toString()};
            throw new AdminProcessingException(AdminPlugin.Util.getString("MMScriptsContainer.files_exist", params));
        }
        if (existingFiles == null || options.containsOption(1)) {
            for (String fileName : this.fileMap.keySet()) {
                File target = new File(path + fileName);
                try {
                    target.createNewFile();
                    byte[] fileContents = (byte[])this.fileMap.get(fileName);
                    FileUtils.write(fileContents, target);
                }
                catch (IOException err) {
                    Object[] params = new Object[]{fileName};
                    throw new AdminProcessingException(AdminPlugin.Util.getString("MMScriptsContainer.error_writing_file", params));
                }
            }
        }
    }

    public void addFile(String fileName, byte[] fileContents) throws AdminComponentException {
        if (fileName == null || fileName.length() == 0) {
            throw new AdminComponentException(AdminPlugin.Util.getString("MMScriptsContainer.fileName_was_null"));
        }
        if (fileContents == null || fileContents.length == 0) {
            throw new AdminComponentException(AdminPlugin.Util.getString("MMScriptsContainer.fileContents_was_null"));
        }
        this.fileMap.put(fileName, fileContents);
    }
}

